/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import uk101.machine.Configuration;
import uk101.machine.Dump;
import uk101.utils.Args;
import uk101.utils.PrintBytes;
import uk101.utils.PrintCode;
import uk101.view.MachineImage;
import uk101.view.ViewImage;

public class PrintMachine {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("hex");
        options.put("code");
        Args parms = new Args(PrintMachine.class, "machine [outputfile]", args, options);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        boolean asHex = parms.getFlag("hex");
        boolean asCode = parms.getFlag("code");
        if (inputFile == null) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        MachineImage image = MachineImage.readImage(inputFile);
        Dump dump = image.imageDump;
        Configuration config = image.imageCfg;
        ViewImage view = image.imageView;
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        output.println("Compukit UK101 Machine Image");
        output.println("created: " + df.format(dump.timestamp));
        output.println();
        if (asHex || asCode) {
            output.println("RAM:");
            ByteArrayInputStream ram = new ByteArrayInputStream(dump.store);
            if (asHex) {
                new PrintBytes(output).print(0, ram);
            } else {
                new PrintCode(output).print(0, ram);
            }
        } else {
            output.println("RAM omitted.");
        }
        output.println();
        if (config != null) {
            output.println("Configuration:");
            output.print(config);
        } else {
            output.println("No configuration.");
        }
        output.println();
        if (view != null) {
            output.println("View details:");
            output.print(view);
        } else {
            output.println("No view details.");
        }
        output.println();
    }
}

