/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import uk101.io.AudioDecoder;
import uk101.io.AudioEncoder;
import uk101.io.Tape;
import uk101.machine.Configuration;
import uk101.machine.TapeRecorder;
import uk101.view.component.CassetteButton;
import uk101.view.component.CassetteLight;
import uk101.view.component.DisplayText;
import uk101.view.component.TapeFormat;
import uk101.view.component.ViewFrame;

public class CassetteView
extends ViewFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private TapeRecorder recorder;
    private JLabel name;
    private DisplayText format;
    private CassetteButton record;
    private CassetteButton play;
    private CassetteButton stop;
    private CassetteLight indicator;
    private JFileChooser select;
    private Timer autoStop;
    private File tapeFile;
    private int inFormat;
    private int outFormat;
    private AudioEncoder audioEncoder;
    private AudioDecoder audioDecoder;

    public CassetteView(TapeRecorder recorder, Configuration cfg) {
        super("Cassette Recorder", true);
        this.recorder = recorder;
        recorder.setView(this);
        this.audioEncoder = cfg.getAudioEncoder();
        this.audioDecoder = cfg.getAudioDecoder();
        this.autoStop = new Timer(15000, this);
        this.autoStop.setRepeats(false);
        this.name = new JLabel(" ");
        this.format = new DisplayText(null, " ", true);
        JPanel tp = new JPanel();
        tp.setLayout(new BoxLayout(tp, 0));
        tp.setBorder(BorderFactory.createTitledBorder("Tape file"));
        tp.add(this.name);
        tp.add(Box.createHorizontalGlue());
        tp.add(this.format);
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 0));
        bp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.record = new CassetteButton("\u25cf", "Rec", Color.RED, this);
        this.play = new CassetteButton("\u25ba", "Play", Color.BLACK, this);
        this.stop = new CassetteButton("\u25a0", "Stop", Color.BLACK, this);
        bp.add(this.record);
        bp.add(Box.createHorizontalStrut(5));
        bp.add(this.play);
        bp.add(Box.createHorizontalStrut(5));
        bp.add(this.stop);
        ButtonGroup group = new ButtonGroup();
        group.add(this.record.button);
        group.add(this.play.button);
        group.add(this.stop.button);
        this.stop.button.setSelected(true);
        this.select = new JFileChooser(new File(".").getAbsolutePath());
        this.select.setAccessory(new TapeFormat());
        this.select.setDialogTitle(String.valueOf(this.getTitle()) + " - Select Tape");
        this.select.setAcceptAllFileFilterUsed(true);
        JPanel ip = new JPanel();
        ip.setLayout(new BoxLayout(ip, 1));
        this.indicator = new CassetteLight();
        this.indicator.setAlignmentX(1.0f);
        ip.add(this.indicator);
        ip.add(Box.createVerticalStrut(8));
        JButton open = new JButton("Open...");
        open.setAlignmentX(1.0f);
        open.addActionListener(this);
        ip.add(open);
        ip.setAlignmentY(1.0f);
        bp.add(Box.createHorizontalStrut(25));
        bp.add(ip);
        Container content = this.getContentPane();
        content.add((Component)tp, "North");
        content.add((Component)bp, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.autoStop) {
            this.stop.button.doClick();
        } else {
            TapeFormat tf = (TapeFormat)this.select.getAccessory();
            tf.reset();
            if (this.select.showDialog(this, "Select") == 0) {
                this.tapeFile = this.select.getSelectedFile();
                this.inFormat = tf.getInputFormat();
                this.outFormat = tf.getOutputFormat();
                this.loadTape();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getItem() == this.record.button) {
                this.play.button.setEnabled(false);
                this.autoStop.start();
                if (this.tapeFile != null) {
                    this.recordTape();
                }
            } else if (e.getItem() == this.play.button) {
                this.record.button.setEnabled(false);
                this.autoStop.start();
                if (this.tapeFile != null) {
                    this.playTape();
                }
            } else if (e.getItem() == this.stop.button) {
                this.play.button.setEnabled(true);
                this.record.button.setEnabled(true);
                this.autoStop.stop();
                if (this.tapeFile != null) {
                    this.stopTape();
                }
            }
        }
    }

    private void loadTape() {
        this.name.setText(this.tapeFile.getName());
        this.format.setValue(" ");
    }

    private void recordTape() {
        OutputStream out = null;
        if (!this.tapeFile.exists()) {
            out = Tape.getOutputStream(this.tapeFile, this.outFormat, this.audioEncoder);
        } else {
            String[] msg = new String[]{"File " + this.tapeFile.getPath() + " already exists.", "Are you sure you want to overwrite it?"};
            Object[] opts = new String[]{"No", "Yes"};
            if (JOptionPane.showInternalOptionDialog(this, msg, this.getTitle(), 0, 2, null, opts, opts[0]) == 1) {
                out = Tape.getOutputStream(this.tapeFile, this.outFormat, this.audioEncoder);
            } else {
                this.stop.button.doClick();
            }
        }
        if (out != null) {
            this.format.setValue(this.tapeFormat(Tape.getFormat(out)));
            this.recorder.setOutputTape(out);
        }
    }

    private void playTape() {
        InputStream in = Tape.getInputStream(this.tapeFile, this.inFormat, this.audioDecoder);
        if (in != null) {
            this.format.setValue(this.tapeFormat(Tape.getFormat(in)));
            this.recorder.setInputTape(in);
        }
    }

    private void stopTape() {
        this.format.setValue(" ");
        this.recorder.setInputTape(null);
        this.recorder.setOutputTape(null);
    }

    private String tapeFormat(int format) {
        return format == 1 ? "ASCII" : (format == 3 ? "Audio" : "Binary");
    }

    public void setRead() {
        this.indicator.setOn(Color.GREEN);
        this.autoStop.restart();
    }

    public void setWrite() {
        this.indicator.setOn(Color.RED);
        this.autoStop.restart();
    }
}

