/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import uk101.machine.Computer;
import uk101.machine.Configuration;
import uk101.view.CassetteView;
import uk101.view.KeyboardView;
import uk101.view.MachineImage;
import uk101.view.MachineView;
import uk101.view.VideoView;
import uk101.view.component.ImageFormat;

public class ComputerView
extends JDesktopPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static boolean isMac;
    static final String IMAGE_LOAD = "Load...";
    static final String IMAGE_SAVE = "Save...";
    private Computer computer;
    private JFileChooser imageSelect;
    private MachineView machine;
    private VideoView video;
    private KeyboardView keyboard;
    private CassetteView cassette;

    static {
        UIManager.put("InternalFrame.useTaskBar", Boolean.FALSE);
        LookAndFeel lf = UIManager.getLookAndFeel();
        isMac = lf != null && (lf.getID().equals("Mac") || lf.getID().equals("Aqua"));
    }

    public ComputerView(Computer computer) {
        this.setLayout(null);
        this.computer = computer;
        this.video = new VideoView(computer.video, computer.config);
        this.keyboard = new KeyboardView(computer, computer.keyboard, computer.config);
        this.cassette = new CassetteView(computer.recorder, computer.config);
        this.machine = new MachineView(computer, this);
        this.video.attachKeyboard(this.keyboard);
        this.keyboard.attachKeyboard(this.keyboard);
        this.cassette.attachKeyboard(this.keyboard);
        this.machine.attachKeyboard(this.keyboard);
        this.add(this.machine.display());
        this.add(this.cassette.display());
        this.add(this.video.display());
        this.add(this.keyboard.display());
        this.imageSelect = new JFileChooser(new File(".").getAbsolutePath());
        this.imageSelect.setDialogTitle("UK101 Machine Image");
        this.imageSelect.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".uk101");
            }

            public String getDescription() {
                return "UK101 Machine Images";
            }
        });
    }

    public boolean defaultLayout() {
        int maxX1 = this.video.getWidth() + this.machine.getWidth() + 5;
        int maxX2 = this.keyboard.getWidth() + this.cassette.getWidth() + 10;
        int maxX = Math.max(maxX1, maxX2);
        int maxY1 = this.keyboard.getHeight() + this.video.getHeight();
        int maxY2 = this.keyboard.getHeight() + this.machine.getHeight();
        int maxY = Math.max(maxY1, maxY2);
        int macX = maxX - this.machine.getWidth();
        int macY = 0;
        this.machine.setLocation(macX, macY);
        int vidX = 0;
        int vidY = 0;
        if (this.video.getWidth() < this.keyboard.getWidth() && (vidX = (this.keyboard.getWidth() - this.video.getWidth()) / 2) + this.video.getWidth() > macX) {
            vidX = 0;
        }
        this.video.setLocation(vidX, vidY);
        int kybX = 0;
        int kybY = maxY - this.keyboard.getHeight();
        if (this.keyboard.getWidth() < this.video.getWidth()) {
            kybX = (this.video.getWidth() - this.keyboard.getWidth()) / 2;
        }
        this.keyboard.setLocation(kybX, kybY);
        int casX = kybX + this.keyboard.getWidth() + 10;
        int casY = maxY - this.cassette.getHeight();
        this.cassette.setLocation(casX, casY);
        Dimension size = new Dimension(maxX, maxY);
        this.setPreferredSize(size);
        return false;
    }

    public void focusKeyboard() {
        try {
            this.keyboard.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(IMAGE_LOAD)) {
            ImageFormat format = new ImageFormat(false);
            this.imageSelect.setAccessory(format);
            if (this.imageSelect.showOpenDialog(this) == 0) {
                File file = this.imageSelect.getSelectedFile();
                MachineImage image = MachineImage.readImage(file);
                image.apply(this.computer, null);
            }
        } else if (e.getActionCommand().equals(IMAGE_SAVE)) {
            ImageFormat format = new ImageFormat(true);
            this.imageSelect.setAccessory(format);
            if (this.imageSelect.showSaveDialog(this) == 0) {
                File file = this.imageSelect.getSelectedFile();
                if (!file.getName().contains(".")) {
                    file = new File(String.valueOf(file.getPath()) + ".uk101");
                }
                ComputerView saveView = format.savePostions() ? this : null;
                Configuration saveCfg = format.saveProperties() ? this.computer.config : null;
                MachineImage image = new MachineImage(this.computer, saveView, saveCfg);
                image.write(file);
            }
        }
    }
}

