/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import uk101.hardware.Keyboard;
import uk101.machine.Computer;
import uk101.machine.Configuration;
import uk101.view.component.KeyboardKey;
import uk101.view.component.KeyboardLock;
import uk101.view.component.ViewFrame;

public class KeyboardView
extends ViewFrame
implements ItemListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    static final String[] KB_ROW1 = new String[]{"! 1", "\" 2", "# 3", "$ 4", "% 5", "& 6", "' 7", "( 8", ") 9", "0", "* :", "= -"};
    static final String[] UK_ROW2 = new String[]{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "@ P", "\u2191 ^"};
    static final String[] UK_ROW3 = new String[]{"A", "S", "D", "F", "G", "H", "LF J", "[ K", "\\ L", "+ ;"};
    static final String[] UK_ROW4 = new String[]{"Z", "X", "ETX C", "V", "B", "N", "] M", "< ,", "> .", "? /"};
    static final String[] US_ROW2 = new String[]{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P"};
    static final String[] US_ROW3 = new String[]{"A", "S", "D", "F", "G", "H", "J", "K", "L", "+ ;"};
    static final String[] US_ROW4 = new String[]{"Z", "X", "C", "V", "B", "N", "M", "< ,", "> .", "? /"};
    private Computer computer;
    private Keyboard keyboard;
    private boolean gameMode;
    private boolean ctrlMode;
    private static final String UK_SHIFT_CHARS = "!\"#$%&'()*=@[\\+]<>?_";
    private static final String US_SHIFT_CHARS = "!\"#$%&'()*=@[\\+]<>?_^";
    private int mappedKey = 0;
    private int mappedShift = 0;
    private String shiftChars;
    private int lfChar;

    public KeyboardView(Computer computer, Keyboard keyboard, Configuration cfg) {
        super("Keyboard", true);
        JPanel row4;
        JPanel row3;
        JPanel row2;
        this.computer = computer;
        this.keyboard = keyboard;
        this.gameMode = this.isGameMode(cfg.getKbdMode());
        JPanel row1 = this.makeRow(KB_ROW1);
        JPanel row5 = this.makeRow(new String[0]);
        if (keyboard.isUK()) {
            row2 = this.makeRow(UK_ROW2);
            row3 = this.makeRow(UK_ROW3);
            row4 = this.makeRow(UK_ROW4);
        } else {
            row2 = this.makeRow(US_ROW2);
            row3 = this.makeRow(US_ROW3);
            row4 = this.makeRow(US_ROW4);
        }
        row1.add(new KeyboardKey("RUB OUT", -1, this));
        if (!keyboard.isUK()) {
            row2.add((Component)new KeyboardKey("ESC", -9, this), 0);
            row2.add(new KeyboardKey("LINE FEED", -2, this));
        }
        row2.add(new KeyboardKey("RETURN", 3, -3, this));
        row3.add((Component)new KeyboardKey("CTRL", -4, this), 0);
        row3.add(new KeyboardLock("SHIFT LOCK", -5, true, this));
        if (!keyboard.isUK()) {
            row3.add(new KeyboardKey("REPT", -10, this));
        }
        row4.add((Component)new KeyboardKey("SHIFT", 3, -6, this), 0);
        row4.add(new KeyboardKey("SHIFT", 3, -7, this));
        row5.add(new KeyboardKey("", 16, -8, this));
        if (keyboard.isUK()) {
            row2.add(KeyboardKey.getOffset(1), 0);
            row5.add(KeyboardKey.getOffset(5), 0);
        } else {
            row1.add(KeyboardKey.getOffset(1), 0);
            row3.add(KeyboardKey.getOffset(1), 0);
            row4.add(KeyboardKey.getOffset(1), 0);
            row5.add(KeyboardKey.getOffset(6), 0);
        }
        if (keyboard.isUK()) {
            row3.add(new KeyboardKey("RESET", -99, this));
            row3.add(new KeyboardKey("RESET", -99, this));
        } else {
            row3.add(new KeyboardKey("BREAK", -99, this));
        }
        if (keyboard.isUK()) {
            this.shiftChars = UK_SHIFT_CHARS;
            this.lfChar = -2;
        } else {
            this.shiftChars = US_SHIFT_CHARS;
            this.lfChar = -2;
        }
        JCheckBox game = new JCheckBox("Game mode", this.gameMode);
        game.setAlignmentY(1.0f);
        game.addItemListener(this);
        row5.add(Box.createHorizontalGlue());
        row5.add(game);
        row5.add(Box.createHorizontalStrut(5));
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.add(row1);
        content.add(row2);
        content.add(row3);
        content.add(row4);
        content.add(row5);
    }

    private JPanel makeRow(String[] names) {
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        row.setAlignmentX(0.0f);
        int i = 0;
        while (i < names.length) {
            row.add(new KeyboardKey(names[i], 0, this));
            ++i;
        }
        return row;
    }

    private boolean isGameMode(String name) {
        return name.equals("game");
    }

    public void mousePressed(MouseEvent e) {
        KeyboardKey key = (KeyboardKey)e.getSource();
        if (key.getCode() != -99) {
            if (!this.gameMode && e.isShiftDown()) {
                this.keyboard.pressKey(-6);
            }
            this.keyboard.pressKey(key.getCode());
        } else {
            int m = e.getModifiersEx();
            if ((m & 0x400) != 0 && (m & 0x1800) != 0) {
                this.computer.reset();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        KeyboardKey key = (KeyboardKey)e.getSource();
        if (key.getCode() != -99) {
            this.keyboard.releaseKey(key.getCode());
            if (!this.gameMode && e.isShiftDown()) {
                this.keyboard.releaseKey(-6);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        KeyboardKey key = (KeyboardKey)e.getSource();
        if (key.getCode() == -99 && e.getClickCount() > 1) {
            this.computer.reset();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() instanceof KeyboardLock) {
            KeyboardLock key = (KeyboardLock)e.getItem();
            if (key.isSelected()) {
                this.keyboard.pressKey(key.getCode());
            } else {
                this.keyboard.releaseKey(key.getCode());
            }
        } else {
            this.gameMode = e.getStateChange() == 1;
            this.computer.setGameMode(this.gameMode);
        }
    }

    public void keyPressed(KeyEvent e) {
        e.consume();
        int key = this.mapKey(e);
        if (key != 0) {
            this.keyboard.pressKey(key);
            if (key == -4) {
                this.ctrlMode = true;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        e.consume();
        this.releaseMapped();
        int key = this.mapKey(e);
        if (key != 0) {
            this.keyboard.releaseKey(key);
            if (key == -4) {
                this.ctrlMode = false;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        char key;
        if (!this.gameMode && !this.ctrlMode && (key = e.getKeyChar()) > '\u001f' && key < '\u007f') {
            this.pressMapped(key);
        }
    }

    private int mapKey(KeyEvent e) {
        int code = e.getKeyCode();
        int location = e.getKeyLocation();
        int key = 0;
        switch (code) {
            case 10: {
                key = -3;
                break;
            }
            case 8: {
                key = -1;
                break;
            }
            case 27: {
                key = -9;
                break;
            }
            case 155: {
                key = -2;
                break;
            }
            case 127: {
                key = -10;
                break;
            }
            case 17: {
                if (this.gameMode && location == 3) {
                    key = -7;
                    break;
                }
                key = -4;
                break;
            }
            case 16: 
            case 525: {
                if (!this.gameMode && !this.ctrlMode) break;
                if (location == 2) {
                    key = -6;
                    break;
                }
                key = -7;
                break;
            }
            default: {
                if (!this.gameMode && !this.ctrlMode) break;
                if (code == 91 || code == 93) {
                    key = this.lfChar;
                    break;
                }
                if (code <= 31 || code >= 127) break;
                key = code;
            }
        }
        return key;
    }

    private void pressMapped(int key) {
        this.releaseMapped();
        if (this.shiftChars.indexOf(key) != -1) {
            this.mappedShift = -6;
            this.keyboard.pressKey(this.mappedShift);
        }
        this.mappedKey = key;
        this.keyboard.pressKey(this.mappedKey);
    }

    private void releaseMapped() {
        if (this.mappedKey != 0) {
            this.keyboard.releaseKey(this.mappedKey);
            this.keyboard.releaseKey(this.mappedShift);
            this.mappedShift = 0;
            this.mappedKey = 0;
        }
    }
}

