/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import uk101.hardware.Memory;
import uk101.hardware.bus.IOBus;
import uk101.hardware.bus.IODevice;
import uk101.machine.Computer;
import uk101.machine.Data;

public class ACIA6850
extends Memory
implements IODevice,
Runnable {
    static final byte STATUS_RDRF = 1;
    static final byte STATUS_TDRE = 2;
    static final byte CONTROL_RESET = 3;
    private byte statusReg = (byte)2;
    private byte txByte;
    private byte rxByte;
    private int txClock;
    private int txTime;
    private int baudRate;
    IOBus txBus;
    IOBus rxBus;

    public ACIA6850(int baud, int priority) {
        super(256);
        this.txClock = baud * 16;
        this.baudRate = baud;
        Thread worker = new Thread(this);
        worker.setName(this.getClass().getSimpleName());
        worker.setPriority(Math.max(1, priority - 1));
        worker.start();
    }

    public synchronized byte readByte(int offset) {
        byte b = 0;
        if ((offset & 1) == 0) {
            b = this.statusReg;
        } else {
            b = this.rxByte;
            if (!Computer.aciaFix1 || offset == 1) {
                this.statusReg = (byte)(this.statusReg & 0xFFFFFFFE);
                this.notify();
            }
        }
        return b;
    }

    public synchronized void writeByte(int offset, byte b) {
        if ((offset & 1) == 0) {
            if (b == 3) {
                this.statusReg = (byte)2;
                this.setSpeed((byte)0);
            } else {
                this.setSpeed(b);
            }
        } else {
            this.txByte = b;
            this.statusReg = (byte)(this.statusReg & 0xFFFFFFFD);
            this.notify();
        }
    }

    public byte traceByte(int offset) {
        return (offset & 1) == 0 ? this.statusReg : this.rxByte;
    }

    private void setSpeed(byte controlReg) {
        int sb = controlReg & 3;
        int wb = controlReg >> 2 & 7;
        int divide = sb == 1 ? 16 : (sb == 2 ? 64 : 1);
        int length = wb == 2 || wb == 3 || wb == 5 ? 10 : 11;
        this.baudRate = this.txClock / divide;
        this.txTime = 1000 * length * divide / this.txClock;
        this.txTime = this.txTime * 2 / 3;
    }

    public synchronized void setTxBus(IOBus bus) {
        this.txBus = bus;
    }

    public synchronized void setRxBus(IOBus bus) {
        this.rxBus = bus;
        if (bus != null) {
            this.notify();
        }
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int rb = -1;
        byte sb = 0;
        while (true) {
            try {
                while (true) {
                    byte tb;
                    boolean rx;
                    boolean tx;
                    ACIA6850 aCIA6850 = this;
                    synchronized (aCIA6850) {
                        if (sb != 0) {
                            this.statusReg = (byte)(this.statusReg | sb);
                        }
                        if (rb != -1) {
                            this.rxByte = (byte)rb;
                        }
                        this.wait();
                        tx = (this.statusReg & 2) == 0;
                        rx = (this.statusReg & 1) == 0;
                        tb = this.txByte;
                        rb = -1;
                        sb = 0;
                    }
                    if (tx) {
                        if (this.txBus != null) {
                            this.txBus.writeByte(tb);
                        } else {
                            Thread.sleep(this.txTime);
                        }
                        sb = (byte)(sb | 2);
                    }
                    if (!rx || this.rxBus == null || (rb = this.rxBus.readByte()) == -1) continue;
                    sb = (byte)(sb | 1);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ACIA").append(super.toString());
        sb.append(" Status=").append(Data.toBinaryString(this.statusReg));
        sb.append(" Tx=").append(Data.toHexString(this.txByte));
        sb.append(" Rx=").append(Data.toHexString(this.rxByte));
        return sb.toString();
    }
}

