/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

class ALU6502 {
    boolean isOverflow = false;
    boolean isCarry = false;
    boolean isDecimal = false;

    ALU6502() {
    }

    void setDecimal(boolean decimal) {
        this.isDecimal = decimal;
    }

    byte add(byte value1, byte value2, boolean carry) {
        int c;
        byte result = 0;
        int n = c = carry ? 1 : 0;
        if (this.isDecimal) {
            int i = this.fromBCD(value1) + this.fromBCD(value2) + c;
            boolean bl = this.isCarry = i > 99;
            if (this.isCarry) {
                i -= 100;
            }
            result = this.toBCD(i);
        } else {
            int uresult = (value1 & 0xFF) + (value2 & 0xFF) + c;
            int sresult = value1 + value2 + c;
            this.isCarry = uresult < 0 || uresult > 255;
            this.isOverflow = sresult > 127 || sresult < -128;
            result = (byte)uresult;
        }
        return result;
    }

    byte sub(byte value1, byte value2, boolean carry) {
        int c;
        byte result = 0;
        int n = c = carry ? 0 : 1;
        if (this.isDecimal) {
            int i = this.fromBCD(value1) - this.fromBCD(value2) - c;
            boolean bl = this.isCarry = i >= 0;
            if (!this.isCarry) {
                i += 100;
            }
            result = this.toBCD(i);
        } else {
            int uresult = (value1 & 0xFF) - (value2 & 0xFF) - c;
            int sresult = value1 - value2 - c;
            this.isCarry = uresult >= 0 && uresult <= 255;
            this.isOverflow = sresult > 127 || sresult < -128;
            result = (byte)uresult;
        }
        return result;
    }

    byte cmp(byte value1, byte value2) {
        int v1 = value1 & 0xFF;
        int v2 = value2 & 0xFF;
        this.isCarry = v1 >= v2;
        return (byte)(v1 - v2);
    }

    byte and(byte value1, byte value2) {
        return (byte)(value1 & value2);
    }

    byte or(byte value1, byte value2) {
        return (byte)(value1 | value2);
    }

    byte xor(byte value1, byte value2) {
        return (byte)(value1 ^ value2);
    }

    byte shl(byte value) {
        this.isCarry = value < 0;
        return (byte)(value << 1);
    }

    byte rol(byte value, boolean carry) {
        this.isCarry = value < 0;
        return (byte)(value << 1 | (carry ? 1 : 0));
    }

    byte shr(byte value) {
        this.isCarry = (value & 1) != 0;
        return (byte)((value & 0xFF) >> 1);
    }

    byte ror(byte value, boolean carry) {
        this.isCarry = (value & 1) != 0;
        return (byte)((value & 0xFF) >> 1 | (carry ? 128 : 0));
    }

    private int fromBCD(byte b) {
        int lo = b & 0xF;
        int hi = b >> 4 & 0xF;
        return lo + 10 * hi;
    }

    private byte toBCD(int i) {
        int lo = i % 10;
        int hi = i / 10 % 10;
        return (byte)(lo + (hi << 4));
    }

    public String toString() {
        StringBuilder s = new StringBuilder("ALU: ");
        s.append(this.isDecimal ? "BCD" : "BIN");
        return s.toString();
    }
}

