/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    private String name;
    private String parms;
    private Map opts;
    private HashMap<String, String> options = new HashMap();
    private List<String> parameters = new ArrayList<String>();

    public static Map optionMap() {
        return new Map();
    }

    public Args(Class<?> cl, String parms, String[] args, Map opts) {
        this(cl.getName(), parms, args, opts);
    }

    public Args(String name, String parms, String[] args, Map opts) {
        this.name = name;
        this.parms = parms;
        this.opts = opts;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String remap;
                if ((arg = arg.substring(1)).equals("?")) {
                    this.usage();
                }
                if (opts != null && opts.containsKey(arg) && (remap = (String)opts.get(arg)) != null && remap.startsWith("=")) {
                    arg = remap.substring(1);
                }
                if (opts != null && opts.containsKey(arg)) {
                    if (opts.get(arg) != null && i < args.length - 1) {
                        this.options.put(arg, args[++i]);
                    } else {
                        this.options.put(arg, null);
                    }
                } else {
                    this.error("Incorrect option", arg, true);
                }
            } else if (arg.equals("?")) {
                this.usage();
            } else {
                this.parameters.add(arg);
            }
            ++i;
        }
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameter(int position) {
        String result = null;
        if (position <= this.parameters.size()) {
            result = this.parameters.get(position - 1);
        }
        return result;
    }

    public List<String> getParameters(int firstPos, int count) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            String result = this.getParameter(firstPos + i);
            if (result == null) break;
            results.add(result);
            ++i;
        }
        return results;
    }

    public String getOption(String option) {
        return this.options.get(option);
    }

    public boolean getFlag(String option) {
        return this.options.containsKey(option);
    }

    public File getInputFile(int position) {
        return this.getNamedInputFile(this.getParameter(position));
    }

    public File getInputFile(String option) {
        return this.getNamedInputFile(this.getOption(option));
    }

    private File getNamedInputFile(String name) {
        File result = null;
        if (!(name == null || (result = new File(name)).exists() && result.isFile() && result.canRead())) {
            this.error("Cannot open input file", name, false);
        }
        return result;
    }

    public List<File> getInputFiles(int position, int count) {
        return this.getNamedInputFiles(this.getParameters(position, count));
    }

    private List<File> getNamedInputFiles(List<String> names) {
        ArrayList<File> results = new ArrayList<File>();
        for (String name : names) {
            results.add(this.getNamedInputFile(name));
        }
        return results;
    }

    public File getOutputFile(int position) {
        return this.getNamedOutputFile(this.getParameter(position));
    }

    public File getOutputFile(String option) {
        return this.getNamedOutputFile(this.getOption(option));
    }

    private File getNamedOutputFile(String name) {
        File result = null;
        if (!(name == null || !(result = new File(name)).exists() || result.isFile() && result.canWrite())) {
            this.error("Cannot open output file", name, false);
        }
        return result;
    }

    public int getInteger(int position, int defaultValue) {
        return this.getIntegerValue(this.getParameter(position), defaultValue);
    }

    public int getInteger(String option, int defaultValue) {
        return this.getIntegerValue(this.getOption(option), defaultValue);
    }

    private int getIntegerValue(String value, int defaultValue) {
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.error("Expected numeric parameter", value, true);
            }
        }
        return result;
    }

    public int getHexInteger(int position, int defaultValue) {
        return this.getHexIntegerValue(this.getParameter(position), defaultValue);
    }

    public int getHexInteger(String option, int defaultValue) {
        return this.getHexIntegerValue(this.getOption(option), defaultValue);
    }

    private int getHexIntegerValue(String value, int defaultValue) {
        int result = defaultValue;
        if (value != null) {
            int radix = 10;
            int factor = 1;
            if (value.startsWith("$")) {
                value = value.substring(1);
                radix = 16;
            } else if (value.startsWith("0x") || value.startsWith("0X")) {
                value = value.substring(2);
                radix = 16;
            } else if (value.endsWith("K") || value.endsWith("k")) {
                value = value.substring(0, value.length() - 1);
                factor = 1024;
            }
            try {
                result = Integer.parseInt(value, radix) * factor;
            }
            catch (NumberFormatException e) {
                this.error("Expected decimal or hex parameter", value, true);
            }
        }
        return result;
    }

    public void usage() {
        System.out.println("Usage:\n");
        if (this.opts == null) {
            System.out.println("  " + this.name + " " + this.parms + "\n");
        } else {
            System.out.println("  " + this.name + " [options] " + this.parms + "\n");
            String hdr = "options:";
            for (String opt : this.opts.keySet()) {
                if (this.opts.values().contains("=" + opt)) continue;
                System.out.print(String.valueOf(hdr) + " -" + opt);
                hdr = "        ";
                String value = (String)this.opts.get(opt);
                if (value != null) {
                    if (value.startsWith("=")) {
                        String remap = value.substring(1);
                        String reval = (String)this.opts.get(remap);
                        value = ", -" + remap;
                        if (reval != null) {
                            value = String.valueOf(value) + " " + reval;
                        }
                    } else {
                        if (value.startsWith("+")) {
                            value = value.substring(1);
                            hdr = "";
                        }
                        value = " " + value;
                    }
                    System.out.print(value);
                }
                if (hdr.length() <= 0) continue;
                System.out.println();
            }
        }
        System.exit(1);
    }

    private void error(String msg, String parm, boolean usage) {
        System.out.println(String.valueOf(msg) + ": " + parm);
        if (usage) {
            System.out.println();
            this.usage();
        }
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;

        public void put(String key) {
            this.put(key, null);
        }
    }
}

