/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import uk101.io.AudioEncoder;

public class Loudspeaker
extends OutputStream {
    private AudioEncoder encoder;
    private SourceDataLine sound;
    private byte[] frame;
    private int length;

    public Loudspeaker(AudioFormat format) throws LineUnavailableException {
        this.sound = AudioSystem.getSourceDataLine(format);
        this.frame = new byte[format.getFrameSize()];
        this.length = 0;
    }

    public Loudspeaker(AudioEncoder enc) throws LineUnavailableException {
        this(enc.getFormat());
        enc.setOutputStream(this);
        this.encoder = enc;
    }

    public void open() throws LineUnavailableException {
        this.sound.open();
        this.sound.start();
    }

    public void close() {
        this.sound.drain();
        this.sound.stop();
        this.sound.close();
    }

    public void write(int b) throws IOException {
        this.frame[this.length++] = (byte)b;
        if (this.length == this.frame.length) {
            this.sound.write(this.frame, 0, this.length);
            this.length = 0;
        }
    }

    public void play(InputStream in) throws IOException {
        if (this.encoder != null) {
            this.encoder.encodeStart();
            this.encoder.encodeStream(in);
            this.encoder.encodeEnd();
        }
    }
}

