/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.FileOutputStream;
import uk101.utils.Args;

public class EraseROM {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("fill", "byte");
        options.put("new", "size");
        Args parms = new Args(EraseROM.class, "romfile", args, options);
        File romFile = parms.getOutputFile(1);
        int fill = parms.getHexInteger("fill", 0);
        int size = parms.getHexInteger("new", 0);
        if (romFile == null || !romFile.exists() && size == 0) {
            parms.usage();
        }
        if (size == 0) {
            size = (int)Math.min(65536L, romFile.length());
        }
        size = (size + 255) / 256 * 256;
        FileOutputStream out = new FileOutputStream(romFile);
        int i = 0;
        while (i < size) {
            out.write(fill);
            ++i;
        }
        out.close();
        System.out.println("Erased ROM:");
        System.out.println("  " + romFile.getCanonicalPath());
        System.out.println("  Size=" + (size % 1024 == 0 ? String.valueOf(size / 1024) + "KB" : String.valueOf(size) + " bytes"));
    }
}

