/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import java.util.HashMap;
import java.util.Map;
import uk101.hardware.Memory;
import uk101.machine.Data;

public class Keyboard
extends Memory {
    public static final int KEY_RUBOUT = -1;
    public static final int KEY_UPARROW = -2;
    public static final int KEY_LINEFEED = -2;
    public static final int KEY_RETURN = -3;
    public static final int KEY_CTRL = -4;
    public static final int KEY_SHIFTLOCK = -5;
    public static final int KEY_LSHIFT = -6;
    public static final int KEY_RSHIFT = -7;
    public static final int KEY_SPACE = -8;
    public static final int KEY_ESC = -9;
    public static final int KEY_REPEAT = -10;
    public static final int KEY_RESET = -99;
    private boolean isUK;
    private Map<Integer, Key> keys;
    private byte[] matrix;
    private byte kbport = (byte)-1;

    public Keyboard(String type) {
        super(1024);
        this.isUK = type.equals("uk");
        this.matrix = new byte[8];
        int i = 0;
        while (i < this.matrix.length) {
            this.matrix[i] = -1;
            ++i;
        }
        this.keys = new HashMap<Integer, Key>();
        this.addKey(49, 33, 7, 7);
        this.addKey(50, 34, 7, 6);
        this.addKey(51, 35, 7, 5);
        this.addKey(52, 36, 7, 4);
        this.addKey(53, 37, 7, 3);
        this.addKey(54, 38, 7, 2);
        this.addKey(55, 39, 7, 1);
        this.addKey(56, 40, 6, 7);
        this.addKey(57, 41, 6, 6);
        this.addKey(48, 64, 6, 5);
        this.addKey(58, 42, 6, 4);
        this.addKey(45, 61, 6, 3);
        this.addKey(-1, 0, 6, 2);
        this.addKey(46, 62, 5, 7);
        this.addKey(76, 108, 5, 6);
        this.addKey(79, 111, 5, 5);
        this.addKey(-3, 0, 5, 3);
        this.addKey(87, 119, 4, 7);
        this.addKey(69, 101, 4, 6);
        this.addKey(82, 114, 4, 5);
        this.addKey(84, 116, 4, 4);
        this.addKey(89, 121, 4, 3);
        this.addKey(85, 117, 4, 2);
        this.addKey(73, 105, 4, 1);
        this.addKey(83, 115, 3, 7);
        this.addKey(68, 100, 3, 6);
        this.addKey(70, 102, 3, 5);
        this.addKey(71, 103, 3, 4);
        this.addKey(72, 104, 3, 3);
        this.addKey(74, 106, 3, 2);
        this.addKey(75, 107, 3, 1);
        this.addKey(88, 120, 2, 7);
        this.addKey(67, 99, 2, 6);
        this.addKey(86, 118, 2, 5);
        this.addKey(66, 98, 2, 4);
        this.addKey(78, 110, 2, 3);
        this.addKey(77, 109, 2, 2);
        this.addKey(44, 60, 2, 1);
        this.addKey(81, 113, 1, 7);
        this.addKey(65, 97, 1, 6);
        this.addKey(90, 122, 1, 5);
        this.addKey(-8, 32, 1, 4);
        this.addKey(47, 63, 1, 3);
        this.addKey(59, 43, 1, 2);
        this.addKey(80, 112, 1, 1);
        this.addKey(-4, 0, 0, 6);
        this.addKey(-6, 0, 0, 2);
        this.addKey(-7, 0, 0, 1);
        this.addKey(-5, 0, 0, 0);
        this.addKey(92, 0, 5, 6);
        this.addKey(91, 0, 3, 1);
        this.addKey(93, 0, 2, 2);
        this.addKey(95, 0, 5, 5);
        if (this.isUK) {
            this.addKey(-2, 94, 5, 4);
        } else {
            this.addKey(-2, 0, 5, 4);
            this.addKey(-9, 0, 0, 5);
            this.addKey(-10, 0, 0, 7);
            this.addKey(94, 0, 2, 3);
        }
        this.pressKey(-5);
    }

    public synchronized byte readByte(int offset) {
        byte b = -1;
        int i = 0;
        int k = this.kbport;
        while (i < this.matrix.length) {
            if ((k & 1) == 0) {
                b = (byte)(b & this.matrix[i]);
            }
            k >>= 1;
            ++i;
        }
        return b;
    }

    public synchronized void writeByte(int offset, byte b) {
        this.kbport = b;
    }

    public synchronized void pressKey(int key) {
        Key k = this.keys.get(key);
        if (k != null) {
            int n = k.row;
            this.matrix[n] = (byte)(this.matrix[n] & ~k.col);
        }
    }

    public synchronized void releaseKey(int key) {
        Key k = this.keys.get(key);
        if (k != null) {
            int n = k.row;
            this.matrix[n] = (byte)(this.matrix[n] | k.col);
        }
    }

    private void addKey(int k1, int k2, int row, int col) {
        Key key = new Key(row, col);
        if (k1 != 0) {
            this.keys.put(k1, key);
        }
        if (k2 != 0) {
            this.keys.put(k2, key);
        }
    }

    public boolean isUK() {
        return this.isUK;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Keyboard: ");
        s.append(Data.toBinaryString(this.kbport)).append(" [");
        int i = 0;
        while (i < this.matrix.length) {
            s.append(" ").append(Data.toBinaryString(this.matrix[i]));
            ++i;
        }
        s.append("] = ").append(Data.toBinaryString(this.readByte(0)));
        return s.toString();
    }

    private static class Key {
        int row;
        byte col;

        Key(int r, int c) {
            this.row = r;
            this.col = (byte)(1 << c);
        }
    }
}

