/*
 * Decompiled with CFR 0.152.
 */
package uk101.hardware;

import java.io.IOException;
import java.util.Arrays;
import uk101.hardware.RAM;
import uk101.hardware.ROM;
import uk101.view.VideoView;

public class Video
extends RAM {
    public int rows;
    public int cols;
    public ROM charSet;
    public int charWidth;
    public int charHeight;
    private VideoView view;

    public Video(int height, int width, ROM chargen) throws IOException {
        super(Video.toK(height * width));
        Arrays.fill(this.store, (byte)32);
        this.rows = height;
        this.cols = width;
        this.charSet = chargen;
        this.charWidth = 8;
        this.charHeight = 8;
    }

    public void writeByte(int offset, byte b) {
        super.writeByte(offset, b);
        if (this.view != null) {
            this.view.updateVideo(offset, b);
        }
    }

    public void setView(VideoView view) {
        this.view = view;
    }

    public String toString() {
        return "Video" + super.toString() + " (" + this.kBytes() + "K) " + this.rows + "x" + this.cols;
    }
}

