/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;

public abstract class AudioEncoder {
    public static final int RATE48K = 48000;
    public static final int BIT16 = 16;
    public static final int BIT8 = 8;
    protected AudioFormat audioFormat;
    protected OutputStream outputStream;
    private boolean sineWave;
    private int bytesPerSample;
    private double maxV;

    protected AudioEncoder(int rate, int bits, boolean sine) {
        this.audioFormat = new AudioFormat(rate, bits, 1, true, true);
        this.bytesPerSample = this.audioFormat.getFrameSize();
        this.sineWave = sine;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    protected byte[] getSamples(int cycles, int freq) {
        int sampleLength = (int)(this.audioFormat.getSampleRate() + (float)(freq / 2)) / freq;
        byte[] data = new byte[sampleLength * this.bytesPerSample * cycles];
        double cycleTime = 1.0 / (double)freq;
        double sampleTime = cycleTime / (double)sampleLength;
        int k = 0;
        int i = 0;
        while (i < cycles) {
            int j = 0;
            while (j < sampleLength) {
                int a = (int)(25600.0 * this.waveFn(sampleTime * (double)j, cycleTime));
                data[k++] = (byte)(a >> 8);
                if (this.bytesPerSample > 1) {
                    data[k++] = (byte)a;
                }
                ++j;
            }
            ++i;
        }
        return data;
    }

    private double waveFn(double t, double w) {
        return this.sineWave ? this.waveFnSin(t, w) : this.waveFnSys(t, w);
    }

    private double waveFnSin(double t, double w) {
        return Math.sin(Math.PI * 2 * (t / w));
    }

    private double waveFnSys(double t, double w) {
        double x = w / 2.0;
        double ev = 0.5;
        double rc = 1.0E-4;
        double mv = ev * (1.0 - Math.exp(-x / rc));
        this.maxV = Math.max(mv, this.maxV);
        double v = ev * (1.0 - Math.exp((t % x - x) / rc)) + (this.maxV - mv) / 2.0;
        double a = 2.0 * v / this.maxV - 1.0;
        return t <= x ? a : 0.0 - a;
    }

    public abstract void encodeStart() throws IOException;

    public abstract void encodeEnd() throws IOException;

    public abstract void encodeByte(int var1) throws IOException;

    public void encodeStream(InputStream in) throws IOException {
        int b = in.read();
        while (b != -1) {
            this.encodeByte(b);
            b = in.read();
        }
    }
}

