/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.IOException;
import uk101.io.AudioEncoder;

public class KansasCityEncoder
extends AudioEncoder {
    public static final int BAUD300 = 300;
    public static final int BAUD600 = 600;
    public static final int BAUD1200 = 1200;
    static final int LO_TONE = 1200;
    static final int HI_TONE = 2400;
    private int baudRate;
    private int leadIn;
    private int leadOut;
    private byte[] bit0;
    private byte[] bit1;

    public KansasCityEncoder(int rate, int bits, int baud) {
        this(rate, bits, baud, true);
    }

    public KansasCityEncoder(int rate, int bits, int baud, boolean sine) {
        super(rate, bits, sine);
        this.baudRate = baud;
        int n = 4 / (this.baudRate / 300);
        this.bit0 = this.getSamples(n, 1200);
        this.bit1 = this.getSamples(2 * n, 2400);
    }

    public void setLeader(int lin, int lout) {
        this.leadIn = lin;
        this.leadOut = lout;
    }

    public void encodeByte(int b) throws IOException {
        this.encodeBit(0);
        int i = 0;
        while (i < 8) {
            this.encodeBit(b & 1);
            b >>= 1;
            ++i;
        }
        this.encodeBit(1);
        this.encodeBit(1);
    }

    private void encodeBit(int b) throws IOException {
        this.outputStream.write(b == 0 ? this.bit0 : this.bit1);
    }

    public void encodeStart() throws IOException {
        this.encodeTone(this.leadIn);
    }

    public void encodeEnd() throws IOException {
        this.encodeTone(this.leadOut);
        this.outputStream.write(this.bit0, 0, this.audioFormat.getFrameSize());
    }

    private void encodeTone(int millis) throws IOException {
        int bits = millis * this.baudRate / 1000;
        int i = 0;
        while (i < bits) {
            this.encodeBit(1);
            ++i;
        }
    }
}

