/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import uk101.io.AudioDecoder;
import uk101.io.AudioEncoder;
import uk101.io.UK101InputStream;
import uk101.io.UK101OutputStream;
import uk101.io.WaveInputStream;
import uk101.io.WaveOutputStream;

public class Tape {
    public static final int STREAM_SELECT = 0;
    public static final int STREAM_ASCII = 1;
    public static final int STREAM_BINARY = 2;
    public static final int STREAM_AUDIO = 3;

    public static OutputStream getOutputStream(File file, int format, AudioEncoder enc) {
        OutputStream out = null;
        try {
            if (format == 1) {
                out = new UK101OutputStream(new FileWriter(file));
            } else if (format == 2) {
                out = new FileOutputStream(file);
            } else if (format == 3) {
                out = new WaveOutputStream(new FileOutputStream(file), enc);
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return out;
    }

    public static InputStream getInputStream(File file, int format, AudioDecoder dec) {
        InputStream in = null;
        try {
            if (format == 0) {
                format = Tape.checkFormat(file, dec);
            }
            if (format == 1) {
                in = new UK101InputStream(new FileReader(file));
            } else if (format == 2) {
                in = new FileInputStream(file);
            } else if (format == 3) {
                in = new WaveInputStream(new FileInputStream(file), dec);
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (UnsupportedAudioFileException e) {
            System.err.println(e);
        }
        return in;
    }

    public static int checkFormat(File file, AudioDecoder dec) throws IOException {
        int format = 1;
        byte[] b = new byte[256];
        FileInputStream in = new FileInputStream(file);
        int size = ((InputStream)in).read(b);
        if (dec != null && size > 3 && b[0] == 82 && b[1] == 73 && b[2] == 70 && b[3] == 70) {
            format = 3;
        } else {
            int i = 0;
            while (i < size && format == 1) {
                if ((b[i] < 32 || b[i] > 126) && b[i] != 13 && b[i] != 10 && b[i] != 9) {
                    format = 2;
                } else if (b[i] == 13 && i + 1 < size && b[i + 1] != 10) {
                    format = 2;
                }
                ++i;
            }
        }
        ((InputStream)in).close();
        return format;
    }

    public static int getFormat(InputStream stream) {
        return stream instanceof WaveInputStream ? 3 : (stream instanceof UK101InputStream ? 1 : 2);
    }

    public static int getFormat(OutputStream stream) {
        return stream instanceof WaveOutputStream ? 3 : (stream instanceof UK101OutputStream ? 1 : 2);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int b = in.read();
        while (b != -1) {
            out.write(b);
            b = in.read();
        }
    }
}

