/*
 * Decompiled with CFR 0.152.
 */
package uk101.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import uk101.machine.Data;

public class UK101OutputStream
extends OutputStream {
    private PrintWriter outputWriter;
    private boolean pendingNewline;

    public UK101OutputStream(Writer out) {
        this(new PrintWriter(out, true));
    }

    public UK101OutputStream(PrintWriter out) {
        this.outputWriter = out;
    }

    public UK101OutputStream(PrintStream out) {
        this(new OutputStreamWriter(out));
    }

    public void write(int ch) throws IOException {
        if (ch != 0) {
            if (ch == 10 && this.pendingNewline) {
                this.outputWriter.println();
                this.pendingNewline = false;
            } else {
                this.checkCR();
                if (ch == 13) {
                    this.pendingNewline = true;
                } else if (ch > 31 && ch < 127 && ch != 92) {
                    this.outputWriter.write(ch);
                } else {
                    this.outputWriter.write("\\" + Data.toHexString((byte)ch));
                }
            }
        }
    }

    public void flush() throws IOException {
        this.checkCR();
        this.outputWriter.flush();
    }

    public void close() throws IOException {
        this.checkCR();
        this.outputWriter.close();
    }

    private void checkCR() {
        if (this.pendingNewline) {
            this.outputWriter.write("\\0D");
            this.pendingNewline = false;
        }
    }
}

