/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import uk101.hardware.ACIA6850;
import uk101.hardware.CPU6502;
import uk101.hardware.EPROM;
import uk101.hardware.Keyboard;
import uk101.hardware.Memory;
import uk101.hardware.RAM;
import uk101.hardware.ROM;
import uk101.hardware.Video;
import uk101.hardware.bus.DataBus;
import uk101.machine.Configuration;
import uk101.machine.Data;
import uk101.machine.Dump;
import uk101.machine.TapeRecorder;
import uk101.machine.Trace;

public class Computer
extends Thread
implements DataBus {
    public static boolean debug = false;
    public static boolean videoFix1 = false;
    public static boolean aciaFix1 = false;
    private static int MONITOR_MONUK01 = 0;
    private static int MONITOR_MONUK02 = 1;
    private static int MONITOR_CEGMON = 2;
    private static int MONITOR_WEMON = 3;
    public String name;
    public String version;
    public CPU6502 cpu;
    public Memory[] memory;
    public RAM ram;
    public ROM basic;
    public ROM monitor;
    public Collection<ROM> roms;
    public Collection<RAM> rams;
    public Collection<EPROM> eproms;
    public Keyboard keyboard;
    public Video video;
    public ACIA6850 acia;
    public TapeRecorder recorder;
    public Configuration config;
    private Trace trace;

    public Computer(Configuration cfg) throws IOException {
        Memory r;
        this.name = this.getClass().getPackage().getImplementationTitle();
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (this.name == null || this.version == null) {
            this.name = "Compukit UK101";
            this.version = "0.0.0";
        }
        this.setName(this.name);
        this.setPriority(Math.max(1, this.getPriority() / 2));
        this.config = cfg;
        this.cpu = new CPU6502(cfg.getCpuSpeed(), cfg.getCpuControl(), this);
        this.memory = new Memory[Memory.toBlocks(65536)];
        this.rams = new ArrayList<RAM>();
        for (Configuration.Mem ram : cfg.getRAMs()) {
            r = new RAM(ram.size);
            this.addMemory(ram.address, r);
            this.rams.add((RAM)r);
        }
        this.ram = new RAM(cfg.getRamSize());
        this.basic = new ROM(cfg.getRomBasic());
        this.monitor = new ROM(cfg.getRomMonitor());
        this.addMemory(cfg.getRamAddr(), this.ram);
        this.addMemory(cfg.getBasicAddr(), this.basic);
        this.addMemory(cfg.getMonitorAddr(), this.monitor);
        this.roms = new ArrayList<ROM>();
        for (Configuration.Mem rom : cfg.getROMs()) {
            r = new ROM(rom.name);
            this.addMemory(rom.address, (ROM)r);
            this.roms.add((ROM)r);
        }
        this.eproms = new ArrayList<EPROM>();
        for (Configuration.Mem eeprom : cfg.getEPROMs()) {
            EPROM e = new EPROM(eeprom.name);
            this.addMemory(eeprom.address, e);
            this.eproms.add(e);
        }
        ROM charset = new ROM(cfg.getRomCharset());
        this.keyboard = new Keyboard(cfg.getKbdLayout());
        this.video = new Video(cfg.getVideoRows(), cfg.getVideoCols(), charset);
        this.acia = new ACIA6850(cfg.getAciaRate(), this.getPriority());
        this.addMemory(cfg.getKbdAddr(), this.keyboard);
        this.addMemory(cfg.getVideoAddr(), this.video);
        this.addMemory(cfg.getAciaAddr(), this.acia);
        this.recorder = new TapeRecorder(this.acia);
        String ms = new String(this.monitor.store, "US-ASCII");
        int mon = MONITOR_MONUK01;
        if (ms.contains("(C)old Start")) {
            mon = MONITOR_MONUK02;
        } else if (ms.contains("CEGMON")) {
            mon = MONITOR_CEGMON;
        } else if (ms.contains("WEMON")) {
            mon = MONITOR_WEMON;
        }
        aciaFix1 = mon == MONITOR_MONUK01 || mon == MONITOR_MONUK02;
        videoFix1 = mon == MONITOR_MONUK02;
    }

    private void addMemory(int base, Memory m) {
        m.base = base;
        int bb = Memory.asBlock(base);
        int i = 0;
        while (i < m.blocks) {
            if (bb + i < this.memory.length) {
                this.memory[bb + i] = m;
            }
            ++i;
        }
    }

    private void addMemory(int base, ROM r) {
        this.addMemory(base, (Memory)r);
        r.patch();
    }

    public void reset() {
        this.cpu.signalReset();
    }

    public void setSpeed(int mhz) {
        this.cpu.setMHz(mhz);
        this.config.setCpuSpeed(mhz);
    }

    public void setGameMode(boolean gameMode) {
        this.config.setKbdMode(gameMode ? "game" : "normal");
    }

    public byte readByte(int addr) {
        int b;
        Memory m = this.memory[Memory.asBlock(addr)];
        if (m != null) {
            b = m.readByte(addr - m.base);
        } else {
            b = Data.getHiByte((short)addr);
            if (videoFix1 && this.cpu.getPC() == 64370) {
                b = 32;
            }
        }
        return (byte)b;
    }

    public void writeByte(int addr, byte value) {
        Memory m = this.memory[Memory.asBlock(addr)];
        if (m != null) {
            m.writeByte(addr - m.base, value);
        }
    }

    public byte traceByte(int addr) {
        Memory m = this.memory[Memory.asBlock(addr)];
        return m != null ? m.traceByte(addr - m.base) : Data.getHiByte((short)addr);
    }

    public void run() {
        this.cpu.signalReset();
        this.cpu.run();
    }

    public void shutdown() {
        this.trace(false);
        this.recorder.shutdown();
        for (EPROM e : this.eproms) {
            e.close();
        }
    }

    public void trace(boolean enable) {
        if (enable) {
            if (this.trace == null) {
                this.trace = new Trace(this);
                this.cpu.trace(this.trace);
            }
        } else if (this.trace != null) {
            this.cpu.trace(null);
            this.trace.write();
            this.trace = null;
        }
    }

    public void dump() {
        Dump dump = new Dump(this);
        dump.write();
    }

    public void restore(Dump dump) {
        this.ram.restore(dump.store);
    }

    public String toString() {
        return "UK101: " + this.ram.kBytes() + "K RAM";
    }

    public Computer(boolean test) throws IOException {
        this.ram = new RAM(4);
        this.monitor = new ROM("MONUK02.ROM");
        this.cpu = new CPU6502(1, "sleep", null);
        this.acia = new ACIA6850(300, 5);
    }
}

