/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import uk101.Main;
import uk101.io.AudioDecoder;
import uk101.io.AudioEncoder;
import uk101.io.KansasCityDecoder;
import uk101.io.KansasCityEncoder;
import uk101.machine.Computer;
import uk101.utils.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
extends Properties {
    private static final long serialVersionUID = 2L;
    public static final String AUTO = "auto";
    public static final String SLEEP = "sleep";
    public static final String YIELD = "yield";
    public static final String SPIN = "spin";
    public static final String WHITE = "white";
    public static final String GREEN = "green";
    public static final String AMBER = "amber";
    public static final String SYNC = "sync";
    public static final String ASYNC = "async";
    public static final String UK = "uk";
    public static final String US = "us";
    public static final String NORMAL = "normal";
    public static final String GAME = "game";
    public static final String SINE = "sine";
    public static final String SYSTEM = "system";
    private static final String CPU_SPEED = "cpu.speed";
    private static final String CPU_CONTROL = "cpu.control";
    private static final String ACIA_ADDR = "acia.address";
    private static final String ACIA_RATE = "acia.rate";
    private static final String RAM_ADDR = "ram.address";
    private static final String RAM_SIZE = "ram.size";
    private static final String MONITOR_ADDR = "monitor.address";
    private static final String BASIC_ADDR = "basic.address";
    private static final String ROM_MONITOR = "rom.monitor";
    private static final String ROM_BASIC = "rom.basic";
    private static final String ROM_CHARSET = "rom.charset";
    private static final String KBD_ADDR = "keyboard.address";
    private static final String KBD_LAYOUT = "keyboard.layout";
    private static final String KBD_MODE = "keyboard.mode";
    private static final String VIDEO_ADDR = "video.address";
    private static final String VIDEO_ROWS = "video.rows";
    private static final String VIDEO_COLS = "video.cols";
    private static final String SCREEN_SIZE = "screen.size";
    private static final String SCREEN_WIDTH = "screen.width";
    private static final String SCREEN_OFFSET = "screen.offset";
    private static final String SCREEN_COLOUR = "screen.colour";
    private static final String SCREEN_UPDATE = "screen.update";
    private static final String AUDIO_RATE = "audio.rate";
    private static final String AUDIO_BITS = "audio.bits";
    private static final String AUDIO_LEAD = "audio.lead";
    private static final String AUDIO_WAVE = "audio.wave";
    private static final String AUDIO_PHASE = "audio.phase";
    private static final String ROM = "rom.";
    private static final String RAM = "ram.";
    private static final String EPROM = "eprom.";
    private static final String WEMON = "WEMON";

    public Configuration(Args parms, Configuration initial) throws IOException {
        String s;
        File f;
        Properties props = new Properties();
        InputStream in = Main.class.getResourceAsStream("/uk101.properties");
        if (in != null) {
            props.load(in);
            in.close();
        }
        if ((f = parms.getInputFile("configuration")) != null) {
            in = new FileInputStream(f);
            props.load(in);
            in.close();
        }
        if ((s = parms.getOption("properties")) != null) {
            StringBuffer sb = new StringBuffer();
            String[] ss = s.replace("\\", "\\\\").split("\\[|\\]");
            int i = 0;
            while (i < ss.length) {
                sb.append(ss[i].replace(',', '\n').replace(';', '\n'));
                if (i + 1 < ss.length) {
                    sb.append("[").append(ss[i + 1]).append("]");
                }
                i += 2;
            }
            in = new ByteArrayInputStream(sb.toString().getBytes("ISO-8859-1"));
            props.load(in);
            in.close();
        }
        this.load(Main.class.getResourceAsStream("rom/uk101.properties"));
        if (initial != null) {
            this.applyProperties(initial);
        }
        this.applyProperties(props);
        if (Computer.debug) {
            List<String> keys = Arrays.asList(this.keySet().toArray(new String[0]));
            Collections.sort(keys);
            System.out.println("Configuration:");
            for (String key : keys) {
                System.out.println("  " + key + "=" + this.get(key));
            }
        }
    }

    private void applyProperties(Properties props) {
        this.applyStr(props, ROM_MONITOR, new String[0]);
        File f = new File(this.getRomMonitor());
        if (f.getName().toUpperCase().startsWith(WEMON)) {
            this.setProperty(MONITOR_ADDR, "F000");
            this.setProperty(ACIA_ADDR, "E000");
            this.setProperty(SCREEN_OFFSET, Integer.toString(this.getScreenOffset() - 1));
        }
        this.applyStr(props, ROM_BASIC, new String[0]);
        this.applyStr(props, ROM_CHARSET, new String[0]);
        this.applyInt(props, CPU_SPEED, 0, 4);
        this.applyStr(props, CPU_CONTROL, AUTO, SLEEP, YIELD, SPIN);
        this.applyInt(props, RAM_SIZE, 4, 40);
        this.applyHex(props, ACIA_ADDR, 0, 65535);
        this.applyStr(props, ACIA_RATE, "110", "300", "600", "1200", "2400", "4800", "9600");
        this.apply(props, ACIA_RATE, "baud.rate", 0, 0, 0, "110", "300", "600", "1200", "2400", "4800", "9600");
        this.applyHex(props, KBD_ADDR, 0, 65535);
        this.applyStr(props, KBD_LAYOUT, UK, US);
        this.apply(props, KBD_LAYOUT, "keyboard", 0, 0, 0, UK, US);
        this.applyStr(props, KBD_MODE, NORMAL, GAME);
        this.applyHex(props, VIDEO_ADDR, 0, 65535);
        this.applyInt(props, VIDEO_ROWS, 16, 32);
        this.applyInt(props, VIDEO_COLS, 32, 64);
        this.applyInt(props, SCREEN_SIZE, 1, 2);
        this.applyInt(props, SCREEN_WIDTH, 16, 64);
        this.applyInt(props, SCREEN_OFFSET, 0, 63);
        this.applyStr(props, SCREEN_COLOUR, WHITE, GREEN, AMBER);
        this.apply(props, SCREEN_COLOUR, "screen.color", 0, 0, 0, WHITE, GREEN, AMBER);
        this.applyStr(props, SCREEN_UPDATE, SYNC, ASYNC);
        this.applyInt(props, AUDIO_RATE, 8000, 96000);
        this.applyStr(props, AUDIO_BITS, "8", "16");
        this.applyInt(props, AUDIO_LEAD, 0, 10);
        this.applyStr(props, AUDIO_WAVE, SINE, SYSTEM);
        this.applyStr(props, AUDIO_PHASE, "0", "90", "180", "270");
        this.applyMem(props, ROM, 0, 0);
        this.applyMem(props, RAM, 1, 64);
        this.applyMem(props, EPROM, 0, 0);
    }

    private void applyInt(Properties props, String key, int min, int max) {
        try {
            this.apply(props, key, key, 10, min, max, new String[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void applyHex(Properties props, String key, int min, int max) {
        try {
            this.apply(props, key, key, 16, min, max, new String[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void applyStr(Properties props, String key, String ... range) {
        this.apply(props, key, key, 0, 0, 0, range);
    }

    private void apply(Properties props, String key, String ukey, int radix, int min, int max, String ... range) {
        String value = props.getProperty(ukey);
        if (value != null) {
            value = value.trim();
            if (radix > 0) {
                int i = Integer.parseInt(value, radix);
                if (i >= min && i <= max) {
                    this.setProperty(key, Integer.toString(i, radix));
                }
            } else if (range.length > 0) {
                String s = value.toLowerCase();
                int i = 0;
                while (i < range.length) {
                    if (s.equals(range[i])) {
                        this.setProperty(key, s);
                    }
                    ++i;
                }
            } else {
                this.setProperty(key, value);
            }
        }
    }

    private void applyMem(Properties props, String prefix, int min, int max) {
        Enumeration<?> k = props.propertyNames();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            String addr = this.hasAddr(key, prefix);
            if (addr == null) continue;
            this.apply(props, String.valueOf(prefix) + addr, key, max > 0 ? 10 : 0, min, max, new String[0]);
        }
    }

    private String hasAddr(String key, String prefix) {
        String hex;
        String addr = null;
        if (key.startsWith(prefix) && (hex = key.substring(prefix.length()).toUpperCase()).matches("[0-9A-F]{4}")) {
            addr = hex;
        }
        return addr;
    }

    public int getCpuSpeed() {
        return this.getInt(CPU_SPEED);
    }

    public String getCpuControl() {
        return this.getString(CPU_CONTROL);
    }

    public int getRamAddr() {
        return this.getHex(RAM_ADDR);
    }

    public int getRamSize() {
        return this.getInt(RAM_SIZE);
    }

    public int getMonitorAddr() {
        return this.getHex(MONITOR_ADDR);
    }

    public int getBasicAddr() {
        return this.getHex(BASIC_ADDR);
    }

    public String getRomMonitor() {
        return this.getString(ROM_MONITOR);
    }

    public String getRomBasic() {
        return this.getString(ROM_BASIC);
    }

    public String getRomCharset() {
        return this.getString(ROM_CHARSET);
    }

    public int getKbdAddr() {
        return this.getHex(KBD_ADDR);
    }

    public String getKbdLayout() {
        return this.getString(KBD_LAYOUT);
    }

    public String getKbdMode() {
        return this.getString(KBD_MODE);
    }

    public int getVideoAddr() {
        return this.getHex(VIDEO_ADDR);
    }

    public int getVideoRows() {
        return this.getInt(VIDEO_ROWS);
    }

    public int getVideoCols() {
        return this.getInt(VIDEO_COLS);
    }

    public int getScreenWidth() {
        return this.getInt(SCREEN_WIDTH);
    }

    public int getScreenOffset() {
        return this.getInt(SCREEN_OFFSET);
    }

    public int getScreenSize() {
        return this.getInt(SCREEN_SIZE);
    }

    public String getScreenColour() {
        return this.getString(SCREEN_COLOUR);
    }

    public String getScreenUpdate() {
        return this.getString(SCREEN_UPDATE);
    }

    public int getAciaAddr() {
        return this.getHex(ACIA_ADDR);
    }

    public int getAciaRate() {
        return this.getInt(ACIA_RATE);
    }

    private int getInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    private int getHex(String key) {
        return Integer.parseInt(this.getProperty(key), 16);
    }

    private String getString(String key) {
        return this.getProperty(key);
    }

    public AudioEncoder getAudioEncoder() {
        int baud = Math.min(Math.max(this.getInt(ACIA_RATE), 300), 1200);
        boolean sine = this.getString(AUDIO_WAVE).equals(SINE);
        KansasCityEncoder kcs = new KansasCityEncoder(this.getInt(AUDIO_RATE), this.getInt(AUDIO_BITS), baud, sine);
        kcs.setLeader(this.getInt(AUDIO_LEAD) * 1000, this.getInt(AUDIO_LEAD) * 1000);
        return kcs;
    }

    public AudioDecoder getAudioDecoder() {
        int baud = Math.min(Math.max(this.getInt(ACIA_RATE), 300), 1200);
        int phase = this.getInt(AUDIO_PHASE);
        KansasCityDecoder kcs = new KansasCityDecoder(baud, phase);
        return kcs;
    }

    public Collection<Mem> getROMs() {
        return this.getMem(ROM, false);
    }

    public Collection<Mem> getRAMs() {
        return this.getMem(RAM, true);
    }

    public Collection<Mem> getEPROMs() {
        return this.getMem(EPROM, false);
    }

    private Collection<Mem> getMem(String prefix, boolean ram) {
        ArrayList<Mem> roms = new ArrayList<Mem>();
        Enumeration<?> k = this.propertyNames();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            String addr = this.hasAddr(key, prefix);
            if (addr == null) continue;
            roms.add(new Mem(addr, this.getProperty(key), ram));
        }
        return roms;
    }

    public void setKbdMode(String mode) {
        this.setString(KBD_MODE, mode);
    }

    public void setCpuSpeed(int speed) {
        this.setInt(CPU_SPEED, speed);
    }

    private void setInt(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    private void setString(String key, String value) {
        this.setProperty(key, value);
    }

    public void write(OutputStream stream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(stream);
        out.writeObject(this);
        out.flush();
    }

    public static Configuration readImage(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(stream);
        Configuration cfg = (Configuration)in.readObject();
        return cfg;
    }

    public static class Mem {
        public int address;
        public int size;
        public String name;

        private Mem(String addr, String value, boolean ram) {
            this.address = Integer.parseInt(addr, 16);
            this.name = value;
            if (ram) {
                this.size = Integer.parseInt(value);
            }
        }
    }
}

