/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

public abstract class Data {
    public static final int BYTE_MASK = 255;
    public static final int WORD_MASK = 65535;

    public static final int asBits(byte b) {
        return b & 0xFF;
    }

    public static final int asBits(short w) {
        return w & 0xFFFF;
    }

    public static final int asInt(byte b) {
        return b;
    }

    public static final int asInt(short w) {
        return w;
    }

    public static final int asAddr(byte b) {
        return b & 0xFF;
    }

    public static final int asAddr(short w) {
        return w & 0xFFFF;
    }

    public static final short getWord(byte bh, byte bl) {
        return (short)((bh & 0xFF) << 8 | bl & 0xFF);
    }

    public static final byte getLoByte(short w) {
        return (byte)w;
    }

    public static final byte getHiByte(short w) {
        return (byte)(w >> 8);
    }

    public static final String toHexString(byte b) {
        StringBuilder result = new StringBuilder();
        String text = Integer.toHexString(Data.asBits(b)).toUpperCase();
        result.append("00", 0, 2 - text.length()).append(text);
        return result.toString();
    }

    public static final String toHexString(short w) {
        StringBuilder result = new StringBuilder();
        String text = Integer.toHexString(Data.asBits(w)).toUpperCase();
        result.append("0000", 0, 4 - text.length()).append(text);
        return result.toString();
    }

    public static final String toHexString(int addr) {
        return Data.toHexString((short)addr);
    }

    public static final String toBinaryString(byte b) {
        StringBuilder result = new StringBuilder();
        String text = Integer.toBinaryString(Data.asBits(b));
        result.append("00000000", 0, 8 - text.length()).append(text);
        return result.toString();
    }
}

