/*
 * Decompiled with CFR 0.152.
 */
package uk101.machine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import uk101.machine.Computer;

public class Dump
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    public String version;
    public Date timestamp;
    public byte[] store;

    public Dump(Computer computer) {
        this.name = computer.name;
        this.version = computer.version;
        this.timestamp = new Date();
        this.store = (byte[])computer.ram.store.clone();
    }

    public void write() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
        String filename = "uk101-" + df.format(this.timestamp) + ".ram";
        try {
            DeflaterOutputStream stream = new DeflaterOutputStream(new FileOutputStream(filename));
            this.write(stream);
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void write(OutputStream stream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(stream);
        out.writeObject(this);
        out.flush();
    }

    public static Dump readDump(File file) {
        Dump dump = null;
        try {
            InflaterInputStream stream = new InflaterInputStream(new FileInputStream(file));
            dump = Dump.readDump(stream);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return dump;
    }

    public static Dump readDump(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(stream);
        Dump dump = (Dump)in.readObject();
        return dump;
    }
}

