/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import uk101.machine.Data;
import uk101.utils.Args;

public class PrintBytes {
    private PrintStream output;

    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("output", "outputfile");
        Args parms = new Args(PrintBytes.class, "bytesfile [address]", args, options);
        File inputFile = parms.getInputFile(1);
        int address = parms.getHexInteger(2, 0);
        File outputFile = parms.getOutputFile("output");
        if (inputFile == null) {
            parms.usage();
        }
        FileInputStream input = new FileInputStream(inputFile);
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        new PrintBytes(output).print(address, input);
        output.println();
    }

    public PrintBytes(PrintStream output) {
        this.output = output;
    }

    public void print(int address, InputStream input) throws IOException {
        byte[] bb = new byte[16];
        int size = input.read(bb);
        while (size != -1) {
            this.output.print(String.valueOf(Data.toHexString(address)) + ": ");
            int i = 0;
            while (i < size) {
                this.output.print(" " + Data.toHexString(bb[i]));
                ++i;
            }
            i = size;
            while (i < 16) {
                this.output.print("   ");
                ++i;
            }
            this.output.print("  [");
            i = 0;
            while (i < size) {
                this.output.print(bb[i] > 31 && bb[i] < 127 ? Character.toString((char)bb[i]) : ".");
                ++i;
            }
            i = size;
            while (i < 16) {
                this.output.print(" ");
                ++i;
            }
            this.output.println("]");
            address += size;
            size = input.read(bb);
        }
    }
}

