/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import uk101.utils.Args;
import uk101.utils.Disassembler;

public class PrintCode {
    private PrintStream output;

    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("output", "outputfile");
        Args parms = new Args(PrintCode.class, "bytesfile [address]", args, options);
        File inputFile = parms.getInputFile(1);
        int address = parms.getHexInteger(2, 0);
        File outputFile = parms.getOutputFile("output");
        if (inputFile == null) {
            parms.usage();
        }
        FileInputStream input = new FileInputStream(inputFile);
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        new PrintCode(output).print(address, input);
    }

    public PrintCode(PrintStream output) {
        this.output = output;
    }

    public void print(int address, InputStream input) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int b = input.read();
        while (b != -1) {
            bout.write(b);
            b = input.read();
        }
        Disassembler disasm = new Disassembler(bout.toByteArray(), address);
        while (disasm.hasNext()) {
            this.output.println(disasm.nextInstruction());
        }
    }
}

