/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;
import uk101.hardware.CPU6502;
import uk101.machine.Data;
import uk101.machine.Trace;
import uk101.utils.Args;
import uk101.utils.Disassembler;

public class PrintTrace {
    static final String SPACES32 = "                                ";

    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("output", "outputfile");
        Args parms = new Args(PrintTrace.class, "tracefile", args, options);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile("output");
        if (inputFile == null) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        Trace trace = Trace.readTrace(inputFile);
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        output.println("UK101 6502 Instruction Trace");
        output.println("created: " + df.format(trace.timestamp));
        output.println();
        Disassembler disasm = new Disassembler();
        Trace.Entry entry = trace.nextEntry();
        while (entry != null) {
            disasm.reset(entry.instruction, entry.length, 0, entry.PC, entry.PC);
            String instr = disasm.nextInstruction();
            output.print(String.valueOf(instr) + SPACES32.substring(instr.length()) + ";");
            output.print(" A=" + Data.toHexString(entry.A));
            if (entry.A > 31 && entry.A < 127) {
                output.print("[" + Character.toString((char)entry.A) + "]");
            } else {
                output.print("   ");
            }
            output.print(" X=" + Data.toHexString(entry.X));
            output.print(" Y=" + Data.toHexString(entry.Y));
            output.print(" S=" + Data.toHexString(entry.S));
            output.print("  P=" + CPU6502.toFlagString(entry.P));
            if (disasm.instrMode > 3) {
                output.print("  EA=" + Data.toHexString(entry.addr));
                output.print("," + Data.toHexString(entry.data));
            }
            output.println();
            entry = trace.nextEntry();
        }
        output.println();
    }
}

