/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import uk101.io.KansasCityDecoder;
import uk101.io.KansasCityEncoder;
import uk101.io.Tape;
import uk101.machine.Loudspeaker;
import uk101.utils.Args;

public class TapePlay {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("binary");
        options.put("sampleRate", "samplerate (8000 to 96000)");
        options.put("sampleSize", "samplesize (8 or 16)");
        options.put("baud", "baudrate (300, 600 or 1200)");
        options.put("leadIn", "+leadin");
        options.put("leadOut", "+leadout");
        options.put("leadGap", "segmentgap");
        options.put("sineWave");
        options.put("inputBaud", "inputbaudrate (300, 600 or 1200)");
        options.put("inputPhase", "inputphaseangle (0, 90, 180 or 270)");
        Args parms = new Args(TapePlay.class, "inputfile(s)", args, options);
        int count = parms.getParameterCount();
        List<File> inputFiles = parms.getInputFiles(1, count);
        int inputFormat = parms.getFlag("binary") ? 2 : 0;
        int sampleRate = parms.getInteger("sampleRate", 48000);
        int sampleSize = parms.getInteger("sampleSize", 16);
        int baudRate = parms.getInteger("baud", 300);
        int leadIn = parms.getInteger("leadIn", 5);
        int leadOut = parms.getInteger("leadOut", leadIn);
        int leadGap = parms.getInteger("leadGap", 2);
        int inputBaud = parms.getInteger("inputBaud", baudRate);
        int inputPhase = parms.getInteger("inputPhase", 90);
        boolean sineWave = parms.getFlag("sineWave");
        if (inputFiles.isEmpty() || sampleRate < 8000 || sampleRate > 96000 || sampleSize != 8 && sampleSize != 16 || baudRate != 300 && baudRate != 600 && baudRate != 1200 || inputBaud != 300 && inputBaud != 600 && inputBaud != 1200 || inputPhase % 90 != 0) {
            parms.usage();
        }
        KansasCityDecoder decoder = new KansasCityDecoder(inputBaud, inputPhase);
        KansasCityEncoder encoder = new KansasCityEncoder(sampleRate, sampleSize, baudRate, sineWave);
        encoder.setLeader(leadIn * 1000, leadOut * 1000);
        Loudspeaker speaker = new Loudspeaker(encoder);
        count = 0;
        speaker.open();
        for (File inputFile : inputFiles) {
            InputStream input = Tape.getInputStream(inputFile, inputFormat, decoder);
            if (count++ > 0) {
                encoder.setLeader(leadGap * 1000, leadOut * 1000);
            }
            speaker.play(input);
            input.close();
        }
        speaker.close();
    }
}

