/*
 * Decompiled with CFR 0.152.
 */
package uk101.utils;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import uk101.io.KansasCityDecoder;
import uk101.io.Tape;
import uk101.utils.Args;

public class TapeWrite {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("adaptive");
        options.put("baud", "baudrate (300, 600 or 1200)");
        options.put("phase", "phaseangle (0, 90, 180 or 270)");
        Args parms = new Args(TapeWrite.class, "inputfile(s) outputtape", args, options);
        int count = parms.getParameterCount();
        List<File> inputFiles = parms.getInputFiles(1, count - 1);
        File outputFile = parms.getOutputFile(count);
        int baudRate = parms.getInteger("baud", 300);
        int phase = parms.getInteger("phase", 90);
        boolean adpative = parms.getFlag("adaptive");
        if (inputFiles.isEmpty() || outputFile == null || baudRate != 300 && baudRate != 600 && baudRate != 1200 || phase % 90 != 0) {
            parms.usage();
        }
        KansasCityDecoder decoder = new KansasCityDecoder(baudRate, phase);
        OutputStream output = Tape.getOutputStream(outputFile, 2, null);
        decoder.setAdaptive(adpative);
        for (File inputFile : inputFiles) {
            InputStream input = Tape.getInputStream(inputFile, 0, decoder);
            Tape.copy(input, output);
            input.close();
        }
        output.close();
    }
}

