/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import uk101.machine.Computer;
import uk101.machine.Configuration;
import uk101.machine.Dump;
import uk101.view.ComputerView;
import uk101.view.ViewImage;

public class MachineImage {
    static final byte HAS_CONFIG = 1;
    static final byte HAS_VIEW = 2;
    public Dump imageDump;
    public Configuration imageCfg;
    public ViewImage imageView;

    public MachineImage() {
    }

    public MachineImage(Computer computer, ComputerView view, Configuration cfg) {
        this.imageDump = new Dump(computer);
        this.imageCfg = cfg;
        if (view != null) {
            this.imageView = new ViewImage(view);
        }
    }

    public boolean apply(Computer computer, ComputerView view) {
        boolean layout = false;
        computer.restore(this.imageDump);
        computer.reset();
        if (view != null && this.imageView != null) {
            layout = this.imageView.layout(view);
        }
        return layout;
    }

    public void write(File file) {
        try {
            DeflaterOutputStream stream = new DeflaterOutputStream(new FileOutputStream(file));
            this.imageDump.write(stream);
            if (this.imageCfg != null || this.imageView != null) {
                int flags = 0;
                if (this.imageCfg != null) {
                    flags |= 1;
                }
                if (this.imageView != null) {
                    flags |= 2;
                }
                ((OutputStream)stream).write(flags);
                if (this.imageCfg != null) {
                    this.imageCfg.write(stream);
                }
                if (this.imageView != null) {
                    this.imageView.write(stream);
                }
            }
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static MachineImage readImage(File file) {
        MachineImage machine = new MachineImage();
        try {
            InflaterInputStream stream = new InflaterInputStream(new FileInputStream(file));
            machine.imageDump = Dump.readDump(stream);
            int flags = ((InputStream)stream).read();
            if (flags != -1) {
                if ((flags & 1) != 0) {
                    machine.imageCfg = Configuration.readImage(stream);
                }
                if ((flags & 2) != 0) {
                    machine.imageView = ViewImage.readImage(stream);
                }
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return machine;
    }
}

