/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk101.machine.Computer;
import uk101.view.ComputerView;
import uk101.view.component.DebugPanel;
import uk101.view.component.DisplayText;
import uk101.view.component.SpeedSelector;
import uk101.view.component.ViewFrame;

public class MachineView
extends ViewFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    static final String MACHINE_DUMP = "Dump";
    static final String MACHINE_TRACE = "Trace";
    static final String MACHINE_RESET = "Reset";
    static final String MACHINE_NMI = " NMI ";
    static final String MACHINE_IRQ = " IRQ ";
    private Computer computer;
    private DisplayText speed;
    private DisplayText baud;
    private SpeedSelector cpuClock;
    private Timer speedTimer;

    public MachineView(Computer computer, ComputerView computerView) {
        super("Machine", true);
        this.computer = computer;
        this.speedTimer = new Timer(2000, this);
        this.speedTimer.setInitialDelay(5000);
        this.speedTimer.setRepeats(true);
        this.speedTimer.start();
        JPanel mp = new JPanel();
        mp.setAlignmentY(0.5f);
        mp.setBorder(BorderFactory.createTitledBorder("Machine"));
        JButton load = new JButton("Load...");
        JButton save = new JButton("Save...");
        load.addActionListener(computerView);
        save.addActionListener(computerView);
        mp.add(load);
        mp.add(Box.createHorizontalStrut(5));
        mp.add(save);
        JPanel ip = new JPanel(new GridLayout(0, 2, 5, 5));
        ip.setAlignmentY(0.5f);
        TitledBorder b1 = BorderFactory.createTitledBorder("Configuration");
        Border b2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        ip.setBorder(BorderFactory.createCompoundBorder(b1, b2));
        this.speed = new DisplayText("CPU", String.valueOf(computer.cpu.getMHz()) + ".00MHz");
        this.baud = new DisplayText("Baud Rate", String.valueOf(computer.acia.getBaudRate()));
        ip.add(this.speed);
        ip.add(this.baud);
        ip.add(new DisplayText("RAM", String.valueOf(computer.ram.kBytes()) + "KB"));
        ip.add(new DisplayText("ROM", computer.monitor.id()));
        JPanel sp = new JPanel();
        sp.setAlignmentY(0.5f);
        sp.setBorder(BorderFactory.createTitledBorder("CPU Clock Speed"));
        this.cpuClock = new SpeedSelector(4, computer.cpu.getMHz(), this);
        sp.add(this.cpuClock);
        AbstractButton[] db = new AbstractButton[]{new JButton(MACHINE_DUMP), new JToggleButton(MACHINE_TRACE), new JButton(MACHINE_RESET), new JButton(MACHINE_NMI), new JButton(MACHINE_IRQ)};
        DebugPanel dp = new DebugPanel(db, this);
        dp.setBorder(BorderFactory.createTitledBorder("Debug"));
        dp.setAlignmentY(0.5f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(mp);
        panel.add(Box.createVerticalStrut(3));
        panel.add(ip);
        panel.add(Box.createVerticalStrut(3));
        panel.add(sp);
        panel.add(Box.createVerticalStrut(3));
        panel.add(dp);
        Container content = this.getContentPane();
        content.add(panel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.speedTimer) {
            this.speed.setValue(String.format("%-1.2fMHz", Float.valueOf(this.computer.cpu.getSpeed())));
            this.baud.setValue(Integer.toString(this.computer.acia.getBaudRate()));
        } else if (e.getActionCommand().equals(MACHINE_DUMP)) {
            this.computer.dump();
        } else if (e.getActionCommand().equals(MACHINE_TRACE)) {
            this.computer.trace(((JToggleButton)e.getSource()).isSelected());
        } else if (e.getActionCommand().equals(MACHINE_RESET)) {
            this.computer.cpu.signalReset();
        } else if (e.getActionCommand().equals(MACHINE_NMI)) {
            this.computer.cpu.signalNMI();
        } else if (e.getActionCommand().equals(MACHINE_IRQ)) {
            this.computer.cpu.signalIRQ();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.cpuClock && !this.cpuClock.getValueIsAdjusting()) {
            this.computer.setSpeed(this.cpuClock.getSpeed());
        }
    }
}

