/*
 * Decompiled with CFR 0.152.
 */
package uk101.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import uk101.hardware.Video;
import uk101.machine.Configuration;
import uk101.view.component.VideoScreen;
import uk101.view.component.ViewFrame;

public class VideoView
extends ViewFrame {
    private static final long serialVersionUID = 1L;
    private VideoScreen screen;
    private int vrows;
    private int vcols;
    private int srows;
    private int scols;
    private int sstart;

    public VideoView(Video video, Configuration cfg) {
        super("Video", false);
        video.setView(this);
        this.vrows = video.rows;
        this.vcols = video.cols;
        this.srows = this.vrows;
        this.scols = cfg.getScreenWidth();
        this.sstart = cfg.getScreenOffset();
        int vscale = this.vrows > 16 ? 1 : 2;
        int hscale = this.vcols > 32 ? 1 : 2;
        int ssize = cfg.getScreenSize() < 2 ? 1 : 2;
        Color colour = this.getScreenColour(cfg.getScreenColour());
        this.screen = new VideoScreen(video, this.srows, this.scols, hscale, vscale, ssize, colour);
        this.screen.setUpdateMode(this.isSyncUpdate(cfg.getScreenUpdate()));
        Dimension cell = this.screen.getCellSize();
        JPanel tv = new JPanel();
        tv.setOpaque(true);
        tv.setBackground(VideoScreen.SCREEN_BLACK);
        tv.setBorder(BorderFactory.createEmptyBorder(cell.height / 2, cell.width / 2, cell.height / 2, cell.width / 2));
        tv.add(this.screen);
        Container content = this.getContentPane();
        content.setBackground(VideoScreen.SCREEN_BLACK);
        content.add(tv);
    }

    private Color getScreenColour(String name) {
        Color colour = VideoScreen.SCREEN_WHITE;
        if (name.equals("green")) {
            colour = VideoScreen.SCREEN_GREEN;
        } else if (name.equals("amber")) {
            colour = VideoScreen.SCREEN_AMBER;
        }
        return colour;
    }

    private boolean isSyncUpdate(String name) {
        return name.equals("sync");
    }

    public void updateVideo(int addr, byte b) {
        int r = addr / this.vcols;
        int c = addr % this.vcols - this.sstart;
        if (r >= 0 && r < this.srows && c >= 0 && c < this.scols) {
            this.screen.screenUpdate(r, c, b);
        }
    }
}

