/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device;

import JCPC.core.Util;
import JCPC.core.cpu.Processor;
import JCPC.core.device.Computer$1;
import JCPC.core.device.ComputerTimer;
import JCPC.core.device.Device;
import JCPC.core.device.floppy.Drive;
import JCPC.core.device.memory.Memory;
import JCPC.ui.Display;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public abstract class Computer
extends Device
implements Runnable {
    protected int currentDrive = 0;
    public static final String DEFAULT_COMPUTER = "CPC6128";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SNAPSHOT = 1;
    public static final int TYPE_DISC_IMAGE = 2;
    public static final int TYPE_TAPE_IMAGE = 3;
    public static final int STOP = 0;
    public static final int STEP = 1;
    public static final int STEP_OVER = 2;
    public static final int RUN = 3;
    public static final int MAX_FRAME_SKIP = 20;
    public static final int MAX_FILE_SIZE = 0xD00000;
    public byte[][] disks = new byte[30][];
    public String[] disknames = new String[30];
    private int a = 0;
    protected Applet applet;
    protected Thread thread = new Thread(this);
    protected boolean stopped = false;
    protected int action = 0;
    protected boolean running = false;
    protected boolean waiting = false;
    protected long startTime;
    protected long startCycles;
    protected String name;
    protected String romPath;
    protected String filePath;
    protected Vector files = null;
    protected Display display;
    protected int frameSkip = 0;
    protected int runTo = -1;
    protected int mode = 0;
    protected long maxResync = 200L;
    protected Vector devices = new Vector();
    protected Vector listeners = new Vector(1);
    protected static byte[] SKIP_BUFFER = new byte[1024];

    public static Computer createComputer(Applet applet, String string) {
        GenericDeclaration genericDeclaration = Util.findClass(null, "JCPC.system.cpc.CPC");
        genericDeclaration = genericDeclaration.getConstructor(Applet.class, String.class);
        return (Computer)((Constructor)genericDeclaration).newInstance(applet, string);
    }

    public Computer(Applet applet, String string) {
        super("Computer: " + string);
        this.applet = applet;
        this.name = string;
        this.thread.start();
    }

    protected void setBasePath(String string) {
        this.romPath = "rom/";
        this.filePath = "file/";
    }

    public void initialise() {
        EventQueue.invokeLater(new Computer$1(this));
    }

    public Device addDevice(Device device) {
        return this.addDevice(device, null);
    }

    public Device addDevice(Device device, String string) {
        if (string != null) {
            device.setName(string);
        }
        this.devices.addElement(device);
        return device;
    }

    public Vector getDevices() {
        return this.devices;
    }

    public InputStream openFile(String object) {
        Object object2;
        try {
            object2 = new URL(this.applet.getCodeBase(), (String)object).openStream();
        }
        catch (Exception exception) {
            object2 = new FileInputStream((String)object);
        }
        if (((String)object).toLowerCase().endsWith(".zip")) {
            object = new ZipInputStream((InputStream)object2);
            ((ZipInputStream)object).getNextEntry();
            object2 = object;
            return object2;
        }
        return object2;
    }

    protected int readStream(InputStream inputStream, byte[] byArray, int n, int n2) {
        return this.readStream(inputStream, byArray, n, n2, true);
    }

    protected int readStream(InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                if (!bl) break;
                throw new Exception("Unexpected end of stream");
            }
            n += n3;
            n2 -= n3;
        }
        return n;
    }

    protected void skipStream(InputStream inputStream, int n) {
        while (n > 0) {
            int n2 = n > 1024 ? 1024 : n;
            inputStream.read(SKIP_BUFFER, 0, n2);
            n -= n2;
        }
    }

    public byte[] getFile(String string) {
        return this.getFile(string, 0xD00000, true);
    }

    public byte[] getFile(String string, int n) {
        return this.getFile(string, n, false);
    }

    public byte[] getFile(String string, int n, boolean bl) {
        Object object;
        Object object2 = new byte[n];
        int n2 = 0;
        try {
            object = null;
            try {
                int n3;
                object = this.openFile(string);
                while (n > 0 && (n3 = ((InputStream)object).read((byte[])object2, n2, n)) != -1) {
                    n2 += n3;
                    n -= n3;
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && n2 < ((byte[])object2).length) {
            object = new byte[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        return object2;
    }

    public abstract void AutoType(String var1);

    public void setDisplay(Display display) {
        this.display = display;
        this.displaySet();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void displaySet() {
    }

    public abstract Processor getProcessor();

    public abstract void reSync();

    public abstract Memory getMemory();

    public byte[] getRom(String object, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            InputStream inputStream = null;
            try {
                int n3;
                object = this.getClass().getResourceAsStream((String)object);
                inputStream = object;
                while (n > 0 && (n3 = inputStream.read(byArray, n2, n)) != -1) {
                    n2 += n3;
                    n -= n3;
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public abstract void prepareAutotype(String var1);

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.mode == 3) {
            if (keyEvent.getID() == 401) {
                this.keyPressed(keyEvent);
                return;
            }
            if (keyEvent.getID() == 402) {
                this.keyReleased(keyEvent);
            }
        }
    }

    public abstract void keyPressed(KeyEvent var1);

    public abstract void keyReleased(KeyEvent var1);

    public abstract void loadEntry(int var1);

    public void loadFile(int n, String string) {
    }

    public abstract Dimension getDisplaySize(boolean var1);

    public void setLarge(boolean bl) {
    }

    public Dimension getDisplayScale(boolean bl) {
        return Display.SCALE_1x2;
    }

    public void start() {
        this.setAction(3);
    }

    public void stop() {
        this.setAction(0);
    }

    public void step() {
        this.setAction(1);
    }

    public void stepOver() {
        this.setAction(2);
    }

    public synchronized void setAction(int n) {
        if (this.running && n != 3) {
            this.action = 0;
            this.getProcessor().stop();
            while (this.running) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
        }
        Thread thread = this.thread;
        synchronized (thread) {
            this.action = n;
            this.thread.notify();
            return;
        }
    }

    public void dispose() {
        this.stopped = true;
        this.stop();
        try {
            this.thread.join();
        }
        catch (Exception exception) {}
        this.thread = null;
        this.display = null;
        this.applet = null;
    }

    protected void emulate(int n) {
        switch (n) {
            case 1: {
                this.getProcessor().step();
                return;
            }
            case 2: {
                this.getProcessor().stepOver();
                return;
            }
            case 3: {
                if (this.runTo == -1) {
                    this.getProcessor().run();
                    return;
                }
                this.getProcessor().runTo(this.runTo);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(actionEvent);
        }
    }

    public String getROMPath() {
        return this.romPath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void reset() {
    }

    public void run() {
        while (!this.stopped) {
            try {
                Thread thread;
                if (this.action == 0) {
                    thread = this.thread;
                    synchronized (thread) {
                        this.thread.wait();
                    }
                }
                if (this.action == 0) continue;
                try {
                    this.running = true;
                    thread = this.thread;
                    synchronized (thread) {
                        this.mode = this.action;
                        this.action = 0;
                    }
                    this.startCycles = this.getProcessor().getCycles();
                    this.startTime = System.currentTimeMillis();
                    this.emulate(this.mode);
                }
                finally {
                    this.running = false;
                    this.fireActionEvent();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void syncProcessor() {
        this.syncProcessor(null, ((this.getProcessor().getCycles() - this.startCycles) * 2000L / this.getProcessor().getCyclesPerSecond() + 1L) / 2L, 200L);
    }

    protected void syncProcessor(ComputerTimer computerTimer) {
        this.syncProcessor(computerTimer, computerTimer.getUpdates(), computerTimer.getDeviation());
    }

    protected void syncProcessor(ComputerTimer computerTimer, long l, long l2) {
        this.startTime += l;
        this.startCycles = this.getProcessor().getCycles();
        long l3 = computerTimer != null ? computerTimer.getCount() : System.currentTimeMillis();
        if (l3 < this.startTime - l2) {
            this.setFrameSkip(0);
            this.startTime = l3;
            return;
        }
        if (l3 > this.startTime) {
            if (this.frameSkip == 20) {
                this.setFrameSkip(0);
                if (computerTimer != null) {
                    computerTimer.resync();
                }
                this.startTime = computerTimer != null ? computerTimer.getCount() : System.currentTimeMillis();
                return;
            }
            this.setFrameSkip(this.frameSkip + 1);
            return;
        }
        try {
            block8: {
                this.setFrameSkip(0);
                long l4 = System.currentTimeMillis();
                while ((computerTimer != null ? computerTimer.getCount() : System.currentTimeMillis()) < this.startTime) {
                    if (computerTimer == null || System.currentTimeMillis() - l4 <= this.maxResync) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break block8;
                }
                return;
            }
            computerTimer.resync();
            System.out.println("resync 2");
            this.startTime = computerTimer.getCount();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setMaxResync(long l) {
        this.maxResync = l;
    }

    public void setFrameSkip(int n) {
        this.frameSkip = n;
    }

    public void displayLostFocus() {
    }

    public void updateDisplay(boolean bl) {
    }

    public String getName() {
        return this.name;
    }

    public void setRunToAddress(int n) {
        this.runTo = n;
    }

    public void clearRunToAddress() {
        this.runTo = -1;
    }

    public int getMode() {
        return this.mode;
    }

    public Drive[] getFloppyDrives() {
        return null;
    }

    public int getCurrentDrive() {
        return this.currentDrive;
    }

    public void setCurrentDrive(int n) {
        this.currentDrive = n;
    }

    public int getIndex() {
        return 0;
    }
}

