/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device;

import JCPC.core.device.Device;

public class IOPort
extends Device {
    public static final int READ = 0;
    public static final int WRITE = 255;
    protected Device inputDevice = null;
    protected int inputPort = 0;
    protected Device outputDevice = null;
    protected int outputPort = 0;
    protected int readMask = 255;
    protected int writeMask = 0;
    protected int input = 255;
    protected int output = 255;
    protected boolean latched = false;

    public IOPort() {
        this(0);
    }

    public IOPort(int n) {
        super("Input/Output Port");
        this.setPortMode(n);
    }

    public void setInputDevice(Device device, int n) {
        this.inputDevice = device;
        this.inputPort = n;
    }

    public void setOutputDevice(Device device, int n) {
        this.outputDevice = device;
        this.outputPort = n;
    }

    public void setPortMode(int n) {
        this.setPortMode(n ^ 0xFF, n);
    }

    public void setPortMode(int n, int n2) {
        this.writeMask = n2;
        this.readMask = n;
    }

    public int getPortMode() {
        return this.writeMask;
    }

    public int readPort(int n) {
        return this.read();
    }

    public void writePort(int n, int n2) {
        this.write(n2);
    }

    public int read() {
        if (!this.latched && this.inputDevice != null) {
            this.input = this.inputDevice.readPort(this.inputPort);
        }
        return this.output & (this.readMask ^ 0xFF) | this.input & this.readMask;
    }

    public void latch() {
        this.input = this.inputDevice == null ? 255 : this.inputDevice.readPort(this.inputPort);
    }

    public void write(int n) {
        this.output = n;
        if (this.inputDevice == null) {
            this.input = n;
        }
        if (this.outputDevice != null && this.writeMask != 0) {
            this.outputDevice.writePort(this.outputPort, n & this.writeMask | this.input & (this.writeMask ^ 0xFF));
        }
    }

    public void setOutput(int n) {
        this.output = n;
    }

    public int getOutput() {
        return this.output;
    }

    public int readOutput() {
        return this.output & this.writeMask;
    }

    public void setInput(int n) {
        this.input = n;
    }

    public int getInput() {
        return this.input;
    }

    public void setLatched(boolean bl) {
        this.latched = bl;
    }

    public boolean isLatched() {
        return this.latched;
    }
}

