/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.keyboard;

import JCPC.core.device.Device;
import JCPC.core.device.keyboard.MatrixKeyboard$KeyMapping;
import java.util.Hashtable;

public class MatrixKeyboard
extends Device {
    public static final int KEY_RIGHT = 65536;
    protected int[] pressMap = new int[4096];
    protected int[][] keyMap;
    protected Hashtable mappings = new Hashtable();

    public MatrixKeyboard(String string, int n, int n2) {
        super("Matrix Keyboard");
        this.keyMap = new int[n2][n];
    }

    public void reset() {
        for (int i = 0; i < this.keyMap.length; ++i) {
            int[] nArray = this.keyMap[i];
            for (int j = 0; j < nArray.length; ++j) {
                this.setKeyMap(j, i, 0);
            }
        }
    }

    protected void setKeyMap(int n, int n2, int n3) {
        int n4 = this.keyMap[n2][n];
        if (n4 != n3) {
            this.keyMap[n2][n] = n3;
            this.keyChanged(n, n2, n4, n3);
        }
    }

    public boolean isKeyPressed(int n, int n2) {
        return n2 >= 0 && n2 < this.keyMap.length && n >= 0 && n < this.keyMap[n2].length && this.keyMap[n2][n] != 0;
    }

    protected void keyChanged(int n, int n2, int n3, int n4) {
    }

    public void addKeyMapping(int n, int n2, int n3) {
        this.mappings.get(new Integer(n));
        MatrixKeyboard$KeyMapping matrixKeyboard$KeyMapping = new MatrixKeyboard$KeyMapping(this);
        this.mappings.put(new Integer(n), matrixKeyboard$KeyMapping);
        matrixKeyboard$KeyMapping.addMapping(n2, n3);
    }

    public void addKeyMappings(int[] nArray) {
        int n = this.keyMap[0].length;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            this.addKeyMapping(nArray[i], i % n, i / n);
        }
    }

    public void addKeyMappings(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] == -1) continue;
                this.addKeyMapping(nArray[i][j], j, i);
            }
        }
    }

    public void removeKeyMapping(int n, int n2, int n3) {
        MatrixKeyboard$KeyMapping matrixKeyboard$KeyMapping = (MatrixKeyboard$KeyMapping)this.mappings.get(new Integer(n));
        if (matrixKeyboard$KeyMapping != null) {
            matrixKeyboard$KeyMapping.removeMapping(n2, n3);
            if (matrixKeyboard$KeyMapping.getCount() == 0) {
                this.mappings.remove(matrixKeyboard$KeyMapping);
            }
        }
    }

    public void keyPressed(int n) {
        this.keyPressed(n, 0);
    }

    public void keyPressed(int n, int n2) {
        this.keyChange(n, n2, 1);
    }

    public void keyReleased(int n) {
        this.keyReleased(n, 0);
    }

    public void keyReleased(int n, int n2) {
        this.keyChange(n, n2, -1);
    }

    protected void keyChange(int n, int n2, int n3) {
        int n4;
        int n5 = 1 << (n & 0x1F);
        n2 = n2 == 3 ? 1 : 0;
        int n6 = n4 = n2 != 0 ? 2048 + n / 32 : n / 32;
        if (n3 != 1 || (this.pressMap[n4] & n5) == 0) {
            MatrixKeyboard$KeyMapping matrixKeyboard$KeyMapping = null;
            if (n2 != 0) {
                matrixKeyboard$KeyMapping = (MatrixKeyboard$KeyMapping)this.mappings.get(new Integer(n | 0x10000));
            }
            if (matrixKeyboard$KeyMapping == null) {
                matrixKeyboard$KeyMapping = (MatrixKeyboard$KeyMapping)this.mappings.get(new Integer(n));
            }
            if (matrixKeyboard$KeyMapping != null) {
                matrixKeyboard$KeyMapping.keyChange(n3);
            }
            if (n3 == 1) {
                int n7 = n4;
                this.pressMap[n7] = this.pressMap[n7] | n5;
                return;
            }
            int n8 = n4;
            this.pressMap[n8] = this.pressMap[n8] & ~n5;
        }
    }
}

