/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.renderer;

import JCPC.core.Util;
import JCPC.core.device.crtc.Basic6845;
import JCPC.core.renderer.Renderer;

public class MonitorRenderer
extends Renderer {
    public static final int HSYNC_MIN = 0x3F0000;
    public static final int HSYNC_MAX = 0x410000;
    public static final int HSYNC_MID = 0x400000;
    public static final int HSYNC_MAX_DEC = 204800;
    public static final int HSYNC_MAX_INC = 204800;
    public static final int HSYNC_ADJUST = 8;
    public static final int HSYNC_FREE_ADJUST = 128;
    public static final int VHOLD_MIN = 250;
    public static final int VHOLD_MAX = 380;
    public static final int VHOLD_MID = 295;
    public static final int VHOLD_MIN_RANGE = 46;
    public static final int VHOLD_MAX_RANGE = 74;
    protected long frequency = 1000000L;
    protected int adder = 65536;
    protected int hPos = 0;
    protected int monHFree = 0x400000;
    protected int monHSync = 0x400000;
    protected int monHHalf = 0x200000;
    protected boolean inHSync = false;
    protected boolean hadHSync = false;
    protected int hStart = 0;
    protected int hLess = 0;
    protected int hMore = 0;
    protected int vPos = 0;
    protected int monitorLine = 0;
    protected int vAdjust = -3;
    protected int vSync = 0;
    protected boolean inVSync = false;
    protected int vSyncMin = 0;
    protected int vSyncMax = 0;
    protected int vSyncLen = 0x800000;
    protected int vhold = 45;
    protected boolean debug = false;

    public MonitorRenderer(String string) {
        super(string);
        this.setVHold(-20);
    }

    public void setCycleFrequency(long l) {
        this.adder = (int)(65536000000L / l);
        System.out.println("Frequency=" + l + ", adder=" + this.adder);
    }

    public void hSyncStart() {
        this.hStart = this.hPos;
        this.hadHSync = true;
        this.inHSync = true;
    }

    public void hSyncEnd() {
        if (this.inHSync) {
            this.inHSync = false;
            this.adjustMoreLess(this.hPos);
        }
    }

    protected void adjustMoreLess(int n) {
        if (n <= this.monHHalf) {
            this.hLess += n - this.hStart;
            this.hPos -= 128;
            return;
        }
        if (this.hStart >= this.monHHalf) {
            this.hMore += n - this.hStart;
            return;
        }
        this.hLess += this.monHHalf - this.hStart;
        this.hMore += n - this.monHHalf;
    }

    public void vSyncStart() {
        if (!this.inVSync) {
            if (this.debug) {
                System.out.println("vSync Start: " + this.vPos + ", hPos=" + this.hPos);
            }
            this.vSync = -this.hPos;
            this.inVSync = true;
        }
    }

    public void vSyncEnd() {
        if (this.inVSync) {
            this.inVSync = false;
            this.vSync += this.hPos;
            this.checkVSync();
            if (this.debug) {
                System.out.println("vSync End: " + this.vPos + ", hPos=" + this.hPos + ", length=" + Integer.toHexString(this.vSync));
            }
        }
    }

    public void hSync() {
    }

    public void vSync(boolean bl) {
    }

    public void vSync() {
    }

    public void clock() {
        this.hPos += this.adder;
        if (this.hPos >= this.monHSync) {
            int n;
            int n2;
            if (this.inHSync) {
                this.adjustMoreLess(this.monHSync);
                this.hStart = 0;
            }
            if (this.hLess > this.hMore) {
                n2 = this.hLess - this.hMore;
                n = Math.min(204800, n2 / 8);
                if (n == 0) {
                    n = n2;
                }
                if ((n2 = n / 128) == 0) {
                    n2 = 1;
                }
            } else if (this.hMore > this.hLess) {
                n2 = this.hMore - this.hLess;
                n = -Math.min(204800, n2 / 8);
                if (n == 0) {
                    n = -n2;
                }
                if ((n2 = n / 128) == 0) {
                    n2 = -1;
                }
            } else if (this.hadHSync) {
                n = this.inHSync ? 0 : 128;
                n2 = n / 128;
            } else {
                n = 0;
                n2 = 0;
            }
            this.hPos -= this.monHSync;
            this.vSync += this.monHSync;
            ++this.monitorLine;
            this.hSync();
            this.monHSync = Math.max(0x3F0000, Math.min(0x410000, this.monHFree + n));
            this.monHFree = Math.max(0x3F0000, Math.min(0x410000, this.monHFree + n2));
            this.hLess = 0;
            this.hMore = 0;
            this.hStart = 0;
            this.hadHSync = this.inHSync;
            ++this.vPos;
            if (this.inVSync || Basic6845.CRTCCollision) {
                this.checkVSync();
            }
        }
    }

    protected void checkVSync() {
        if (this.vPos >= this.vSyncMin && (this.vSync > this.monHSync || this.vPos >= this.vSyncMax)) {
            boolean bl = this.vSync - this.monHSync < this.monHHalf;
            this.monitorLine = (250 - this.vPos) / 2 + this.vAdjust - (bl ? 1 : 0);
            if (this.debug) {
                System.out.println("VSync: vPos=" + this.vPos + ", VH-vP=" + (250 - this.vPos) + ", vSync=" + Util.hex(this.vSync) + ", row=" + this.monitorLine + ", monHSync=" + Util.hex(this.monHSync) + ", inVSync=" + this.inVSync + ", interlace=" + bl + ", hPos=" + this.hPos);
            }
            if (Basic6845.CRTCCollision) {
                this.vSync();
            } else {
                this.vSync(bl);
            }
            this.vPos = 0;
        }
    }

    public void setVHold(int n) {
        this.vSyncMin = n + 295;
        this.vSyncMax = this.vSyncMin + 46 + Math.round((this.vSyncMin - 250) * 28 / 130);
    }

    public void setVerticalAdjust(int n) {
        this.vAdjust = n;
    }
}

