/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.device.memory.DynamicMemory;

public class CPCMemory
extends DynamicMemory {
    public static int upperRom;
    protected int ramtype = 0;
    public static final int TYPE_64K = 0;
    public static final int TYPE_128K = 1;
    public static final int TYPE_256K = 15;
    public static final int TYPE_SILICON_DISC = 240;
    public static final int TYPE_128_SILICON_DISC = 241;
    public static final int TYPE_512K = 255;
    protected int[] baseRAM = new int[8];
    protected int[] readMap = new int[8];
    protected int[] writeMap = new int[8];
    protected int type;
    protected boolean lower = true;
    protected boolean upper = true;
    protected int upperROM = 0;
    protected int bankRAM = -1;
    protected static final int BASE_RAM = 0;
    protected static final int BASE_LOWROM = 9;
    protected static final int BASE_UPROM = 10;
    protected static final int BASE_MULTIFACE = 26;

    public CPCMemory(int n) {
        super("CPC Memory", 65536, 27);
        this.ramtype = n;
        this.setRAMType(n);
        this.reset();
    }

    public void reset() {
        this.setRAMBank(192);
        this.upper = false;
        this.lower = true;
        this.upperROM = 0;
        this.remap();
    }

    public void setRAMType(int n) {
        this.type = n;
        this.getMem(0, 65536);
        for (n = 1; n < 9; ++n) {
            if ((this.type & 1) != 0) {
                this.getMem(n, 65536);
            } else {
                this.freeMem(n, 65536);
            }
            this.type >>= 1;
        }
    }

    public int getRAMType() {
        return this.type;
    }

    public void setLowerROM(byte[] byArray) {
        this.setROM(9, byArray);
    }

    public void setMultiROM(byte[] byArray) {
        this.setROM(26, byArray);
    }

    public void setUpperROM(int n, byte[] byArray) {
        this.setROM(10 + (n & 0xF), byArray);
    }

    protected void setROM(int n, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            this.freeMem(n, 16384);
        } else {
            n = this.getMem(n, 16384);
            System.arraycopy(byArray, 0, this.mem, n, Math.min(16384, byArray.length));
        }
        this.remap();
    }

    public void setLowerEnabled(boolean bl) {
        if (this.lower != bl) {
            this.lower = bl;
            this.remap();
        }
    }

    public void setUpperEnabled(boolean bl) {
        if (this.upper != bl) {
            this.upper = bl;
            this.remap();
        }
    }

    public void setUpperROM(int n) {
        upperRom = n;
        if (this.upperROM != (n &= 0xF)) {
            this.upperROM = n;
            this.remap();
        }
    }

    public int getUpperROM() {
        return upperRom;
    }

    public void setRAMBank(int n) {
        if (this.bankRAM != (n &= 0x3F)) {
            this.bankRAM = n;
            this.remapRAM();
            this.remap();
        }
    }

    public int getRAMBank() {
        return this.bankRAM | 0xC0;
    }

    protected void remapRAM() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (this.ramtype == 1 || this.ramtype == 241) {
            n2 = 1;
        }
        if (this.ramtype == 15) {
            n3 = 1;
        }
        if (this.ramtype == 241 || this.ramtype == 240) {
            bl = true;
        }
        if (n2 != 0) {
            n = 7;
        }
        if (n3 != 0) {
            n |= 0x1F;
        }
        if (bl) {
            n |= 0x3F;
        }
        if (n != 0) {
            this.bankRAM &= n;
        }
        n = ((this.bankRAM & 0x38) >> 3) + 1;
        if ((n = this.baseAddr[n]) == -1) {
            n = this.baseAddr[0];
            this.bankRAM = 0;
        }
        n2 = (this.bankRAM & 7) == 2 ? n : this.baseAddr[0];
        for (n3 = 0; n3 < 8; ++n3) {
            this.baseRAM[n3] = n2 + (n3 << 13);
        }
        if ((this.bankRAM & 5) == 1) {
            this.baseRAM[6] = n + 49152;
            this.baseRAM[7] = n + 57344;
            if ((this.bankRAM & 2) == 2) {
                this.baseRAM[2] = n2 + 49152;
                this.baseRAM[3] = n2 + 57344;
                return;
            }
        } else if ((this.bankRAM & 4) == 4) {
            this.baseRAM[2] = n + ((this.bankRAM & 3) << 14);
            this.baseRAM[3] = this.baseRAM[2] + 8192;
        }
    }

    public int readByte(int n) {
        return this.mem[this.readMap[n >> 13] + (n & 0x1FFF)] & 0xFF;
    }

    public int writeByte(int n, int n2) {
        this.mem[this.writeMap[n >> 13] + (n & 0x1FFF)] = (byte)n2;
        return n2 & 0xFF;
    }

    protected void remap() {
        this.mapRAM();
        this.mapROMs();
    }

    protected void mapRAM() {
        for (int i = 0; i < 8; ++i) {
            this.readMap[i] = this.writeMap[i] = this.baseRAM[i];
        }
    }

    protected void mapROMs() {
        int n;
        if (this.lower && (n = this.baseAddr[9]) != -1) {
            this.readMap[0] = n;
            this.readMap[1] = n + 8192;
        }
        if (this.upper) {
            n = this.baseAddr[10 + this.upperROM];
            if (n == -1) {
                n = this.baseAddr[10];
            }
            if (n != -1) {
                this.readMap[6] = n;
                this.readMap[7] = n + 8192;
            }
        }
    }

    public void writePort(int n, int n2) {
        if (n == 64510 || n == 64494) {
            return;
        }
        this.setUpperROM(n2 & 0xF);
    }

    public int readPort(int n) {
        int n2 = 255;
        if (n == 65278) {
            n2 = 160;
        }
        return n2;
    }

    public int readByte(int n, Object object) {
        return this.readByte(n);
    }
}

