/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.crtc.CRTCListener;
import JCPC.core.renderer.MonitorRenderer;
import JCPC.system.cpc.CPC;
import JCPC.system.cpc.CPCMemory;
import JCPC.system.cpc.GateArray$BorderRenderer;
import JCPC.system.cpc.GateArray$FullEndRenderer;
import JCPC.system.cpc.GateArray$FullRenderer;
import JCPC.system.cpc.GateArray$FullStartRenderer;
import JCPC.system.cpc.GateArray$Renderer;
import JCPC.system.cpc.GraphicsDecoder;
import JCPC.system.cpc.Z80;
import java.awt.Dimension;

public final class GateArray
extends MonitorRenderer
implements CRTCListener {
    protected static final GraphicsDecoder decoder;
    protected final int HOFFSET = 718848;
    protected final int HOFFSEND = 3864576;
    protected Dimension FULL_DISPLAY_SIZE = new Dimension(768, 272);
    private static int a;
    private static int b;
    public static CPC cpc;
    public static Z80 z80;
    protected Basic6845 crtc;
    protected int r52;
    protected int vSyncInt = 0;
    protected int interruptMask;
    protected int hSyncCount;
    protected int vSyncCount = 0;
    protected int screenMode = -1;
    protected int newMode = 0;
    protected boolean outHSync = false;
    public static int[] inks;
    protected byte[] fullMap;
    protected byte[] halfMap;
    protected int offset = 0;
    protected int scanStart = 0;
    protected boolean scanStarted;
    protected GateArray$Renderer borderRenderer;
    protected GateArray$Renderer syncRenderer;
    protected GateArray$Renderer defRenderer;
    protected GateArray$Renderer startRenderer;
    protected GateArray$Renderer endRenderer;
    protected GateArray$Renderer renderer;
    protected int endPix;
    protected int selInk = 0;
    protected boolean render = true;
    protected boolean rendering = true;
    public static byte[] screenmemory;
    protected boolean halfSize = false;
    protected int Luminance = 255;
    protected static final int[] maTranslate;
    protected static int[] CPCInks;
    protected static int[] CPCInksb;
    protected int[] GAInks = new int[]{13, 27, 19, 25, 1, 7, 10, 16, 28, 29, 24, 26, 6, 8, 15, 17, 30, 31, 18, 20, 0, 2, 9, 11, 4, 22, 21, 23, 3, 5, 12, 14};
    protected static final int[] inkTranslateCPCe;
    protected static final byte[][] fullMaps;

    public GateArray(CPC cPC) {
        super("Amstrad Gate Array");
        this.setCycleFrequency(1000000L);
        cpc = cPC;
        z80 = cPC.z80;
        this.crtc = cPC.crtc;
        this.reset();
        this.setHalfSize();
    }

    public final void setHalfSize() {
        if (this.defRenderer == null) {
            this.defRenderer = new GateArray$FullRenderer(this);
            this.startRenderer = new GateArray$FullStartRenderer(this);
            this.endRenderer = new GateArray$FullEndRenderer(this);
            this.borderRenderer = new GateArray$BorderRenderer(this, 16, 16);
            this.syncRenderer = new GateArray$BorderRenderer(this, 32, 16);
            this.renderer = this.borderRenderer;
        }
    }

    public final void reset() {
        this.r52 = 0;
        this.setScreenMode(1);
        for (int i = 0; i < 33; ++i) {
            GateArray.inks[i] = -16777216;
        }
        GateArray.inks[16] = -8355712;
    }

    public final void setSelectedInk(int n) {
        this.selInk = (n & 0x1F) < 16 ? n & 0xF : 16;
    }

    public final int getSelectedInk() {
        return this.selInk;
    }

    public final void setInk(int n, int n2) {
        GateArray.CPCInks[n] = this.GAInks[n2 & 0x1F];
        GateArray.CPCInksb[n] = n2;
        GateArray.inks[n] = inkTranslateCPCe[n2 & 0x1F];
    }

    public static int getInks(int n) {
        return CPCInksb[n];
    }

    public final void writePort(int n, int n2) {
        if ((n2 & 0x80) == 0) {
            if ((n2 & 0x40) == 0) {
                this.selInk = (n2 &= 0x1F) < 16 ? n2 : 16;
                return;
            }
            GateArray.CPCInks[this.selInk] = this.GAInks[n2 & 0x1F];
            GateArray.CPCInksb[this.selInk] = n2 & 0x1F;
            GateArray.inks[this.selInk] = inkTranslateCPCe[n2 & 0x1F];
            return;
        }
        CPCMemory cPCMemory = (CPCMemory)cpc.getMemory();
        if ((n2 & 0x40) == 0) {
            this.setModeAndROMEnable(cPCMemory, n2);
            return;
        }
        cPCMemory.setRAMBank(n2);
        b = n2;
    }

    public final int getRAMBank() {
        return b;
    }

    public final void setModeAndROMEnable(CPCMemory cPCMemory, int n) {
        a = n;
        cPCMemory.setLowerEnabled((n & 4) == 0);
        cPCMemory.setUpperEnabled((n & 8) == 0);
        if ((n & 0x10) != 0) {
            this.r52 = 0;
            this.setInterruptMask(this.interruptMask & 0x70);
        }
        this.newMode = n & 3;
    }

    public final int getMode() {
        return a;
    }

    public final void setScreenMode(int n) {
        this.screenMode = n;
        this.fullMap = fullMaps[n];
    }

    public final int getScreenMode() {
        return this.screenMode;
    }

    public final void setInterruptMask(int n) {
        this.interruptMask = n;
        if (this.interruptMask != 0) {
            z80.setInterrupt(1);
            return;
        }
        z80.clearInterrupt(1);
    }

    public final void setInterrupt(int n) {
        this.r52 &= 0x1F;
        this.setInterruptMask(this.interruptMask & 0x70);
    }

    public final void cycle() {
        this.crtc.avoidCollision();
        if (this.hSyncCount == 3 || this.hSyncCount == 4) {
            this.modeCheck();
        }
        if (this.scanStarted) {
            this.crtc.checkHDisp();
            if (this.hPos < 3864576) {
                this.renderer.render();
            } else {
                this.endRenderer.render();
                this.scanStarted = false;
                this.render = false;
            }
        } else if (this.render && this.hPos >= 718848) {
            this.startRenderer.render();
            this.scanStarted = true;
        }
        this.crtc.cycle();
        if (this.inHSync) {
            ++this.hSyncCount;
            if (this.hSyncCount == 2) {
                this.outHSync = true;
                super.hSyncStart();
            }
            if (this.hSyncCount == 6) {
                this.endHSync();
            }
        }
        this.clock();
    }

    protected final void endHSync() {
        if (this.outHSync) {
            super.hSyncEnd();
        }
        this.outHSync = false;
        this.modeCheck();
    }

    public final void modeCheck() {
        if (this.screenMode != this.newMode) {
            this.setScreenMode(this.newMode);
        }
    }

    public final void hSyncStart() {
        this.hSyncCount = 0;
        this.inHSync = true;
        this.renderer = this.syncRenderer;
    }

    public final void hSync() {
        this.modeCheck();
        this.render = this.rendering && this.monitorLine >= -4 && this.monitorLine < 268;
        if (this.render) {
            this.offset = this.scanStart;
            this.scanStart += this.halfSize ? 384 : 768;
        }
        if (this.vSyncCount > 0 && --this.vSyncCount == 0) {
            super.vSyncEnd();
        }
        this.scanStarted = false;
    }

    public final void hSyncEnd() {
        this.debug = cpc.getMode() != 3;
        this.endHSync();
        if (++this.r52 == 52) {
            this.r52 = 0;
            this.setInterruptMask(this.interruptMask | 0x80);
        }
        if (this.vSyncInt > 0 && --this.vSyncInt == 0) {
            if (this.r52 >= 32) {
                this.setInterruptMask(this.interruptMask | 0x80);
            }
            this.r52 = 0;
        }
        this.renderer = this.vSyncCount > 0 ? this.syncRenderer : (this.crtc.isVDisp() && this.crtc.isHDisp() ? this.defRenderer : this.borderRenderer);
    }

    public final void hDispEnd() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : this.borderRenderer;
    }

    public final void hDispStart() {
        this.renderer = this.vSyncCount > 0 || this.crtc.isHSync() ? this.syncRenderer : (this.crtc.isVDisp() ? this.defRenderer : this.borderRenderer);
    }

    public final void vSyncStart() {
        super.vSyncStart();
        this.vSyncCount = 25;
        this.renderer = this.syncRenderer;
        this.vSyncInt = 2;
    }

    public final void vSyncEnd() {
    }

    public final void vSync(boolean bl) {
        this.offset = 0;
        this.scanStart = 0;
        cpc.vSync();
    }

    public final void vSync() {
        this.scanStart = 0;
        try {
            cpc.vSync();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void vDispStart() {
    }

    public final void setMemory(byte[] byArray) {
        screenmemory = byArray;
    }

    public final void setRendering(boolean bl) {
        this.rendering = bl;
        if (!this.rendering) {
            this.scanStarted = false;
            this.render = false;
        }
    }

    public final Dimension getDisplaySize(boolean bl) {
        return this.FULL_DISPLAY_SIZE;
    }

    public final void cursor() {
    }

    public final void init() {
        this.crtc.init();
    }

    public final int PEEK(int n) {
        return cpc.PEEK(n);
    }

    public final void POKE(int n, int n2) {
        cpc.POKE(n, n2);
    }

    static /* synthetic */ int[] a(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] b(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int a(GateArray gateArray) {
        return gateArray.hPos;
    }

    static /* synthetic */ int[] c(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] d(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] e(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] f(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] g(GateArray gateArray) {
        return gateArray.pixels;
    }

    static /* synthetic */ int[] h(GateArray gateArray) {
        return gateArray.pixels;
    }

    static {
        int n;
        decoder = new GraphicsDecoder();
        a = 0;
        b = 0;
        inks = new int[33];
        maTranslate = new int[65536];
        CPCInks = new int[33];
        CPCInksb = new int[33];
        inkTranslateCPCe = new int[]{0x6D6D55, 0x6D6D55, 65365, 0xFFFF55, 85, 0xFF0055, 27989, 16739669, 0xFF0055, 0xFFFF55, 0xFFFF00, 0xFEFEFE, 0xFF0000, 0xFF00FF, 16739584, 0xFF6DFF, 85, 65365, 65280, 65535, 0, 255, 27904, 28159, 7143509, 7208789, 7208704, 0x6DFFFF, 0x6D0000, 7143679, 0x6D6D00, 0x6D6DFF};
        fullMaps = new byte[4][];
        for (n = 0; n < 4; ++n) {
            byte[] byArray = new byte[0x100000];
            GateArray.fullMaps[n] = byArray;
            for (int i = 0; i < 524288; i += 4) {
                int n2 = i >> 3 & 0xFF;
                int n3 = i >> 11 & 0xFF;
                decoder.decodeFull(byArray, i << 1, n, n2);
                decoder.decodeFull(byArray, (i += 4) << 1, n, n3);
            }
        }
        for (n = 0; n < maTranslate.length; ++n) {
            int n4 = n << 1;
            GateArray.maTranslate[n] = n4 & 0x7FE | (n4 & 0x6000) << 1;
        }
    }
}

