/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.cpu;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.core.device.DeviceMapping;

public abstract class Processor
extends Device {
    public int actualAddress;
    protected Device memory;
    protected DeviceMapping[] inputDevice = new DeviceMapping[0];
    protected DeviceMapping[] outputDevice = new DeviceMapping[0];
    protected Device cycleDevice = null;
    protected Device interruptDevice = null;
    protected int interruptPending = 0;
    protected long cycles = 0L;
    protected long cyclesPerSecond;
    protected boolean stopped = false;

    public Processor(String string, long l) {
        super(string);
        this.cyclesPerSecond = l;
    }

    public final void cycle(int n) {
        while (n > 0) {
            this.cycle();
            --n;
        }
    }

    public void cycle() {
        ++this.cycles;
        this.cycleDevice.cycle();
    }

    public void reset() {
        this.cycles = 0L;
    }

    public long getCycles() {
        return this.cycles;
    }

    public abstract void step();

    public abstract void stepOver();

    public void run() {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped);
    }

    public void runTo(int n) {
        this.stopped = false;
        do {
            this.step();
        } while (!this.stopped && this.getProgramCounter() != n);
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    public final int readWord(int n) {
        return this.readByte(n) + (this.readByte(n + 1 & 0xFFFF) << 8);
    }

    public final void writeWord(int n, int n2) {
        this.writeByte(n, n2);
        this.writeByte(n + 1 & 0xFFFF, n2 >> 8);
    }

    public int readByte(int n) {
        return this.memory.readByte(n);
    }

    public int writeByte(int n, int n2) {
        return this.memory.writeByte(n, n2);
    }

    public final int in(int n) {
        int n2 = 255;
        for (int i = 0; i < this.inputDevice.length; ++i) {
            n2 &= this.inputDevice[i].readPort(n);
        }
        return n2;
    }

    public final void out(int n, int n2) {
        for (int i = 0; i < this.outputDevice.length; ++i) {
            this.outputDevice[i].writePort(n, n2);
        }
    }

    public final void setMemoryDevice(Device device) {
        this.memory = device;
    }

    public final Device getMemoryDevice() {
        return this.memory;
    }

    public final void addInputDeviceMapping(DeviceMapping deviceMapping) {
        this.inputDevice = (DeviceMapping[])Util.arrayInsert(this.inputDevice, this.inputDevice.length, 1, deviceMapping);
    }

    public final void removeInputDeviceMapping(DeviceMapping deviceMapping) {
        this.inputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.inputDevice, deviceMapping);
    }

    public final void addOutputDeviceMapping(DeviceMapping deviceMapping) {
        this.outputDevice = (DeviceMapping[])Util.arrayInsert(this.outputDevice, this.outputDevice.length, 1, deviceMapping);
    }

    public final void removeOutputDeviceMapping(DeviceMapping deviceMapping) {
        this.outputDevice = (DeviceMapping[])Util.arrayDeleteElement(this.outputDevice, deviceMapping);
    }

    public final void setCycleDevice(Device device) {
        this.cycleDevice = device;
    }

    public final void setInterruptDevice(Device device) {
        this.interruptDevice = device;
    }

    public void setInterrupt(int n) {
        this.interruptPending |= n;
    }

    public void clearInterrupt(int n) {
        this.interruptPending &= ~n;
    }

    public abstract String getState();

    public abstract int getProgramCounter();

    public long getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    public void setCyclesPerSecond(long l) {
        this.cyclesPerSecond = l;
    }
}

