/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.memory;

import JCPC.core.device.memory.Memory;

public class DynamicMemory
extends Memory {
    protected byte[] mem = new byte[0];
    protected int[] baseAddr;

    public DynamicMemory(String string, int n, int n2) {
        super(string, n);
        this.baseAddr = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.baseAddr[i] = -1;
        }
    }

    protected int getMem(int n, int n2) {
        if (this.baseAddr[n] == -1) {
            this.baseAddr[n] = this.mem.length;
            byte[] byArray = new byte[this.mem.length + n2];
            if (this.mem.length > 0) {
                System.arraycopy(this.mem, 0, byArray, 0, this.mem.length);
            }
            this.mem = byArray;
        }
        return this.baseAddr[n];
    }

    protected void freeMem(int n, int n2) {
        if (this.baseAddr[n] != -1) {
            int n3 = this.baseAddr[n];
            this.baseAddr[n] = -1;
            byte[] byArray = new byte[this.mem.length - n2];
            if (n3 > 0) {
                System.arraycopy(this.mem, 0, byArray, 0, n3);
            }
            if (n3 < byArray.length) {
                System.arraycopy(this.mem, n3 + n2, byArray, n3, byArray.length - n3);
            }
            for (int i = 0; i < this.baseAddr.length; ++i) {
                if (this.baseAddr[i] <= n3) continue;
                int n4 = i;
                this.baseAddr[n4] = this.baseAddr[n4] - n2;
            }
        }
    }

    public byte[] getMemory() {
        return this.mem;
    }
}

