/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.sound;

import JCPC.core.device.sound.JavaSound;
import JCPC.core.device.sound.SoundPlayer;

public class SoundUtil {
    public static final int ULAW = 0;
    public static final int PCM8 = 1;
    public static final int UPCM8 = 2;
    public static final int PCM16 = 3;
    public static final int UPCM16 = 4;
    protected static int[] ULAW_TO_PCM16;
    protected static byte[] PCM16_TO_ULAW;
    protected static int[] PCM16_RANGE;
    protected static int[] ULAW_PREFIX;

    public static SoundPlayer getSoundPlayer(int n, boolean bl) {
        return new JavaSound(n, bl);
    }

    public static final byte pcm16ToULaw(int n) {
        int n2;
        if (n < 0) {
            n = -n;
            n2 = 255;
        } else {
            n2 = 127;
        }
        if ((n >>= 3) >= 8160) {
            n = 8159;
        }
        return (byte)(PCM16_TO_ULAW[n] & n2);
    }

    public static final byte upcm16ToULaw(int n) {
        return SoundUtil.pcm16ToULaw(n - 32768);
    }

    public static final byte pcm8ToULaw(byte by) {
        return SoundUtil.pcm16ToULaw(by << 8);
    }

    public static final byte upcm8ToULaw(byte by) {
        return SoundUtil.pcm16ToULaw(by - 128 << 8);
    }

    public static final int ulawToPCM16(byte by) {
        if ((by & 0x80) == 0) {
            return ULAW_TO_PCM16[by] << 3;
        }
        return -(ULAW_TO_PCM16[by & 0x7F] << 3);
    }

    public static final int ulawToUPCM16(byte by) {
        return SoundUtil.ulawToPCM16(by) + 32768;
    }

    public static final byte ulawToPCM8(byte by) {
        return (byte)((by & 0x80) == 0 ? ULAW_TO_PCM16[by] >> 5 : -(ULAW_TO_PCM16[by & 0x7F] >> 5));
    }

    public static final byte ulawToUPCM8(byte by) {
        return (byte)(SoundUtil.ulawToPCM8(by) + 128);
    }

    static {
        int n;
        int n2;
        ULAW_TO_PCM16 = new int[128];
        PCM16_TO_ULAW = new byte[8160];
        PCM16_RANGE = new int[]{0, 32, 96, 224, 480, 992, 2016, 4064, 8160};
        ULAW_PREFIX = new int[]{240, 224, 208, 192, 176, 160, 144, 128};
        block0: for (n2 = 0; n2 < 8160; ++n2) {
            for (n = 0; n < PCM16_RANGE.length - 1; ++n) {
                if (n2 >= PCM16_RANGE[n + 1]) continue;
                SoundUtil.PCM16_TO_ULAW[n2] = (byte)(ULAW_PREFIX[n] | 15 - (n2 - PCM16_RANGE[n]) / (2 << n));
                continue block0;
            }
        }
        for (n2 = 0; n2 < 127; ++n2) {
            n = 7 - (n2 >> 4);
            int n3 = PCM16_RANGE[n];
            SoundUtil.ULAW_TO_PCM16[n2] = n3 + ((15 - (n2 & 0xF) << 1) + 1) * (1 << n);
        }
    }
}

