/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.sound;

import JCPC.core.device.sound.SoundPlayer;
import JCPC.core.device.sound.SoundUtil;
import JCPC.core.device.sound.SunAudio$AudioStream;
import java.io.InputStream;

public class SunAudio
extends SoundPlayer
implements Runnable {
    protected SunAudio$AudioStream stream;
    protected boolean playing = false;
    protected int samples;
    protected boolean stereo;
    protected int updates;

    public synchronized void stop(InputStream inputStream) {
    }

    public synchronized void start(InputStream inputStream) {
    }

    public SunAudio(int n, boolean bl) {
        this.samples = n;
        this.stereo = bl;
        this.init();
    }

    protected void init() {
        this.stream = new SunAudio$AudioStream(this, this.samples);
    }

    public int getSampleRate() {
        return 8000;
    }

    public long getDeviation() {
        return 1600L;
    }

    public long getUpdates() {
        int n = this.updates;
        this.updates = 0;
        return n;
    }

    public long getCount() {
        return System.currentTimeMillis();
    }

    public void play() {
        if (!this.playing) {
            this.stream.sync();
            this.playing = true;
            Thread thread = new Thread(this);
            thread.setPriority(10);
            thread.start();
        }
    }

    public void stop() {
        if (this.playing) {
            this.stop(this.stream);
            this.playing = false;
        }
    }

    public void dispose() {
        this.stop();
    }

    public void resync() {
        this.stream.sync();
    }

    public void run() {
        if (this.playing) {
            this.start(this.stream);
        }
        while (this.playing) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void writeStereo(int n, int n2) {
        this.stream.writeulaw((byte)(n | n2));
        switch (this.format) {
            case 0: {
                this.stream.writeulaw((byte)(n | n2));
                break;
            }
            case 1: {
                this.stream.writeulaw(SoundUtil.pcm8ToULaw((byte)(n | n2)));
                break;
            }
            case 2: {
                this.stream.writeulaw(SoundUtil.upcm8ToULaw((byte)(n | n2)));
                break;
            }
            case 3: {
                this.stream.writeulaw(SoundUtil.pcm16ToULaw(n + n2));
                break;
            }
            case 4: {
                this.stream.writeulaw(SoundUtil.upcm16ToULaw(n + n2));
            }
        }
        ++this.updates;
    }
}

