/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.cpu.Processor;
import JCPC.core.device.Computer;
import JCPC.core.device.DeviceMapping;
import JCPC.core.device.crtc.Basic6845;
import JCPC.core.device.floppy.DiscImage;
import JCPC.core.device.floppy.Drive;
import JCPC.core.device.floppy.UPD765A;
import JCPC.core.device.io.PPI8255;
import JCPC.core.device.memory.Memory;
import JCPC.core.device.sound.AY_3_8910;
import JCPC.core.device.sound.AmDrum;
import JCPC.core.device.sound.DigiBlaster;
import JCPC.core.device.tape.CDT2WAV;
import JCPC.system.cpc.CPC$1;
import JCPC.system.cpc.CPCDiscImage;
import JCPC.system.cpc.CPCMemory;
import JCPC.system.cpc.GateArray;
import JCPC.system.cpc.Keyboard;
import JCPC.system.cpc.Z80;
import JCPC.ui.Autotype;
import JCPC.ui.Display;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CPC
extends Computer {
    private int a;
    protected AY_3_8910 psg = (AY_3_8910)this.addDevice(new AY_3_8910());
    protected final int[] PSG_VALUES;
    protected static final int PSG_PORT_A = -1;
    protected static final int PPI_PORT_B = -2;
    protected static final int PPI_PORT_C = -3;
    protected static final int CYCLES_PER_SECOND = 1000000;
    protected static final int AUDIO_TEST = 0x40000000;
    protected Z80 z80;
    public static CPCMemory memory = new CPCMemory(255);
    protected Basic6845 crtc;
    protected GateArray gateArray;
    protected PPI8255 ppi;
    protected UPD765A fdc;
    protected Keyboard keyboard;
    protected int audioAdd;
    protected int audioCount;
    protected Drive[] floppies;
    protected AmDrum amdrum;
    protected DigiBlaster digiblaster;
    private int b;
    private boolean a;
    private boolean b;
    private int c;
    private int d;
    private int e;
    public static int tapePosition = 0;
    private int f;
    public static byte[] tapesample = new byte[0];
    private boolean c;
    private int g;
    private int h;
    private long a;
    private boolean d;
    private String[] a;
    private int i;
    private int j;
    private int k;
    protected int BUFFER_START;
    private boolean e;
    Autotype a;
    private int l;
    private String a;
    private int m;
    private int n;
    protected boolean resna;
    protected boolean stosna;
    protected static final String CDT_HEADER = "ZXTAPE";
    protected static final String SNA_HEADER = "MV - SNA";
    protected static final String CSW_HEADER = "Compressed Square Wave";
    protected static final int CRTC_FLAG_VSYNC_ACTIVE = 1;
    protected static final int CRTC_FLAG_HSYNC_ACTIVE = 2;
    protected static final int CRTC_FLAG_HDISP_ACTIVE = 4;
    protected static final int CRTC_FLAG_VDISP_ACTIVE = 8;
    protected static final int CRTC_FLAG_HTOT_REACHED = 16;
    protected static final int CRTC_FLAG_VTOT_REACHED = 32;
    protected static final int CRTC_FLAG_MAXIMUM_RASTER_COUNT_REACHED = 64;
    protected static final int SNAPSHOT_ID = 0;
    protected static final int VERSION = 16;
    protected static final int F = 17;
    protected static final int A = 18;
    protected static final int C = 19;
    protected static final int B = 20;
    protected static final int E = 21;
    protected static final int D = 22;
    protected static final int L = 23;
    protected static final int H = 24;
    protected static final int AF = 17;
    protected static final int BC = 19;
    protected static final int DE = 21;
    protected static final int HL = 23;
    protected static final int R = 25;
    protected static final int I = 26;
    protected static final int IFF1 = 27;
    protected static final int IFF2 = 28;
    protected static final int IX = 29;
    protected static final int IY = 31;
    protected static final int SP = 33;
    protected static final int PC = 35;
    protected static final int IM = 37;
    protected static final int AF1 = 38;
    protected static final int BC1 = 40;
    protected static final int DE1 = 42;
    protected static final int HL1 = 44;
    protected static final int GA_PEN = 46;
    protected static final int GA_INKS = 47;
    protected static final int GA_ROM = 64;
    protected static final int GA_RAM = 65;
    protected static final int CRTC_REG = 66;
    protected static final int CRTC_REGS = 67;
    protected static final int UPPER_ROM = 85;
    protected static final int PPI_A = 86;
    protected static final int PPI_B = 87;
    protected static final int PPI_C = 88;
    protected static final int PPI_CONTROL = 89;
    protected static final int PSG_REG = 90;
    protected static final int PSG_REGS = 91;
    protected static final int MEM_SIZE = 107;
    private byte[] a;
    private CDT2WAV a = 7;
    public boolean saveallowed;

    public CPC(Applet applet, String string) {
        super(applet, string);
        int[] nArray = new int[4];
        nArray[0] = this.psg.BC2_MASK;
        this.psg.getClass();
        this.psg.getClass();
        nArray[1] = 3;
        this.psg.getClass();
        this.psg.getClass();
        nArray[2] = 6;
        this.psg.getClass();
        this.psg.getClass();
        this.psg.getClass();
        nArray[3] = 7;
        this.PSG_VALUES = nArray;
        this.z80 = new Z80(1000000L);
        this.crtc = (Basic6845)this.addDevice(new Basic6845());
        this.gateArray = (GateArray)this.addDevice(new GateArray(this));
        this.ppi = (PPI8255)this.addDevice(new PPI8255());
        this.fdc = (UPD765A)this.addDevice(new UPD765A(4));
        this.keyboard = new Keyboard();
        this.audioAdd = this.psg.getSoundPlayer().getClockAdder(0x40000000, 1000000);
        this.audioCount = 0;
        this.floppies = new Drive[2];
        this.amdrum = (AmDrum)this.addDevice(new AmDrum());
        this.digiblaster = (DigiBlaster)this.addDevice(new DigiBlaster());
        this.b = false;
        this.c = 0;
        this.d = 0;
        this.e = 0;
        this.f = 22;
        this.c = false;
        this.a = 0L;
        this.i = -1;
        this.j = 0;
        this.k = 0;
        this.BUFFER_START = 44170;
        this.e = false;
        this.l = 0;
        this.a = null;
        this.m = 1;
        this.n = 1;
        this.a = new CDT2WAV();
        this.saveallowed = false;
        this.z80.setMemoryDevice(memory);
        this.z80.addOutputDeviceMapping(new DeviceMapping(memory, 8192, 0));
        this.z80.setInterruptDevice(this.gateArray);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.gateArray, 49152, 16384));
        this.z80.setCycleDevice(this);
        this.crtc.setRegisterSelectMask(768, 0);
        this.crtc.setRegisterWriteMask(768, 256);
        this.crtc.setRegisterReadMask(768, 768);
        this.crtc.setRegisterStatusMask(768, 512);
        this.crtc.setCRTCListener(this.gateArray);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.crtc, 16384, 0));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.crtc, 16384, 0));
        this.ppi.setPortMasks(256, 256, 512, 512);
        this.ppi.setReadDevice(1, this, -2);
        this.ppi.setWriteDevice(2, this, -3);
        this.ppi.setReadDevice(0, this.psg, 0);
        this.ppi.setWriteDevice(0, this.psg, 0);
        this.psg.setReadDevice(this.psg.PORT_A, this, -1);
        this.psg.setClockSpeed(1000000);
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.ppi, 2048, 0));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.ppi, 2048, 0));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.fdc, 1408, 256));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.fdc, 1408, 256));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this, 1409, 0));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.amdrum, 65280, 65280));
        this.z80.addInputDeviceMapping(new DeviceMapping(this.amdrum, 65280, 65280));
        this.z80.addOutputDeviceMapping(new DeviceMapping(this.digiblaster, 4096, 0));
        for (int i = 0; i < 2; ++i) {
            this.floppies[i] = new Drive(i == 0 ? 1 : 2);
            this.fdc.setDrive(i, this.floppies[i]);
            this.fdc.setDrive(i, null);
        }
        this.setBasePath("cpc");
    }

    public void initialise() {
        memory.setLowerROM(this.getRom("roms/OS6128.ROM", 16384));
        memory.setUpperROM(0, this.getRom("roms/BASIC1-1.ROM", 16384));
        memory.setUpperROM(7, this.getRom("roms/AMSDOS.ROM", 16384));
        this.gateArray.setMemory(memory.getMemory());
        super.initialise();
        this.psg.getSoundPlayer().play();
    }

    public int storing() {
        return this.fdc.saveTimer;
    }

    public void reset() {
        super.reset();
        this.a = 0L;
        this.gateArray.init();
        memory.reset();
        this.z80.reset();
        tapePosition = 0;
        this.e = 0;
        this.c = false;
        this.reSync();
    }

    public void dispose() {
        super.dispose();
        this.psg.getSoundPlayer().dispose();
    }

    public void cycle() {
        this.fdc.cycle();
        if ((this.audioCount += this.audioAdd / this.m) >= 0x40000000) {
            this.psg.writeAudio();
            this.audioCount -= 0x40000000;
        }
        if (this.crtc.Scratchdemo) {
            if (this.d) {
                this.gateArray.cycle();
                this.gateArray.cycle();
                ++this.a;
            }
            if (this.a > 17128089L) {
                this.crtc.Scratchdemo = false;
                this.a = 0L;
            }
            this.d = !this.d;
        } else {
            if (!this.crtc.Scratchdemo) {
                this.a = 0L;
            }
            this.a = 0L;
            this.gateArray.cycle();
        }
        if (this.a && this.c) {
            AY_3_8910.tape = true;
            this.tapeCycle();
            return;
        }
        AY_3_8910.tape = false;
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.gateArray.setDisplay(display);
    }

    public void setFrameSkip(int n) {
        super.setFrameSkip(n);
        this.gateArray.setRendering(n == 0);
    }

    public void AutoType(String string) {
        string = string.replace("\r", "");
        this.a = string.split("\n");
        this.i = this.a.length - 1;
        this.k = 0;
        this.e = true;
    }

    public void autotype() {
        if (this.a == null) {
            this.a = new Autotype();
            this.a.setVisible(false);
            this.a.send.addActionListener(new CPC$1(this));
        }
        this.a.setVisible(true);
    }

    public void BasicAutoType() {
        if (this.a == null) {
            this.i = -1;
            this.e = false;
            return;
        }
        if (this.k >= this.i) {
            this.e = false;
        }
        if (this.k > this.i) {
            this.e = false;
            this.k = 0;
            this.i = -1;
            this.a = null;
            return;
        }
        this.BasicPutText(this.a[this.k++]);
    }

    public void BasicPutText(String string) {
        int n;
        if (string.length() > 255) {
            return;
        }
        if (string.length() <= 0) {
            this.j = 1;
            return;
        }
        for (n = 0; n < 255; ++n) {
            memory.writeByte(this.BUFFER_START + n, 0);
        }
        for (n = 0; n < string.length(); ++n) {
            memory.writeByte(this.BUFFER_START + n, string.charAt(n));
        }
        System.out.println(string);
        this.j = 1;
    }

    public void prepareAutotype(String string) {
        this.l = 1;
        this.a = string;
    }

    public void vSync() {
        if (this.n != this.m) {
            this.n = this.m;
            this.reSync();
        }
        if (this.l != 0) {
            ++this.l;
            if (this.l == 70) {
                this.l = 0;
                this.AutoType(this.a);
            }
        }
        this.m = this.e ? 4 : 1;
        this.display.turbo = this.e;
        if (this.i >= 0) {
            ++this.j;
            if (this.j == 1) {
                this.BasicAutoType();
            }
            if (this.j == 2) {
                this.keyboard.keyPressed(10);
            }
            if (memory.readByte(this.BUFFER_START) == 0 && this.j > 3) {
                this.j = 0;
                this.keyboard.keyReleased(10);
            }
        }
        if (this.stosna) {
            this.stosna = false;
            this.storeSNA();
            return;
        }
        if (this.resna) {
            this.resna = false;
            this.restoreSNA();
            return;
        }
        if (this.frameSkip == 0) {
            this.display.updateImage();
        }
        this.syncProcessor(this.psg.getSoundPlayer());
        if (this.b && this.c > 0) {
            ++this.c;
            if (this.c == 2) {
                this.StopTape();
                this.c = 0;
            }
        }
    }

    public Memory getMemory() {
        return memory;
    }

    public Processor getProcessor() {
        return this.z80;
    }

    public Dimension getDisplaySize(boolean bl) {
        return this.gateArray.getDisplaySize(true);
    }

    public Dimension getDisplayScale(boolean bl) {
        return Display.SCALE_1x2;
    }

    public int readPort(int n) {
        int n2 = 255;
        switch (n) {
            case -3: {
                n2 = 1;
                break;
            }
            case -2: {
                n2 = 0x50 | this.a << 1 | (this.crtc.isVSync() ? 1 : 0) | this.g;
                break;
            }
            case -1: {
                n2 = this.keyboard.readSelectedRow();
            }
        }
        return n2;
    }

    public void writePort(int n, int n2) {
        switch (n) {
            case -3: {
                this.psg.setBDIR_BC2_BC1(this.PSG_VALUES[n2 >> 6], this.ppi.readOutput(0));
                this.keyboard.setSelectedRow(n2 & 0xF);
                if ((n2 & 0x20) == 32) {
                    AY_3_8910.digicount = 1;
                }
                if (((n2 ^ this.b) & 0x10) == 0 && (n2 & 0x10) != 16) break;
                this.TapeRelayCheck(n2);
                return;
            }
            default: {
                if ((n & 0x581) != 0 || n < 64000) break;
                if ((n2 & 1) == 0) {
                    Display.ledOn = false;
                    return;
                }
                Display.ledOn = true;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 122) {
            return;
        }
        if (keyEvent.getKeyCode() == 119) {
            return;
        }
        if (keyEvent.getKeyCode() == 120) {
            this.e = !this.e;
        }
        this.keyboard.keyPressed(keyEvent.getKeyCode());
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 122) {
            this.autotype();
            return;
        }
        if (keyEvent.getKeyCode() == 119) {
            this.display.crtc = 150;
            if (Basic6845.CRTC == 0) {
                Basic6845.CRTC = 1;
                return;
            }
            Basic6845.CRTC = 0;
            return;
        }
        this.keyboard.keyReleased(keyEvent.getKeyCode());
        if (keyEvent.getKeyCode() == 115) {
            this.stosna = true;
            this.display.storesna = 150;
        }
        if (keyEvent.getKeyCode() == 116) {
            this.resna = true;
            this.display.restoresna = 150;
        }
    }

    public void loadFile(int n, String string) {
        byte[] byArray = this.getFile(string);
        if (SNA_HEADER.equals(new String(byArray, 0, SNA_HEADER.length()))) {
            this.a = byArray;
            this.resna = true;
            return;
        }
        if (CDT_HEADER.equals(new String(byArray, 0, CDT_HEADER.length()).toUpperCase())) {
            System.out.println("Open CDT tape file");
            this.CDT_Load(string, byArray);
            return;
        }
        if (CSW_HEADER.equals(new String(byArray, 0, CSW_HEADER.length())) || string.toUpperCase().endsWith(".CSW")) {
            System.out.println("Open CSW tape file");
            this.CSWLoad(string, byArray);
            return;
        }
        this.DSK_Load(string, byArray);
        this.reSync();
    }

    public void reSync() {
        this.psg.getSoundPlayer().resync();
    }

    private void a(byte[] byArray) {
        int n;
        this.z80.stop();
        this.z80.setAF(CPC.getWord(byArray, 17));
        this.z80.setBC(CPC.getWord(byArray, 19));
        this.z80.setDE(CPC.getWord(byArray, 21));
        this.z80.setHL(CPC.getWord(byArray, 23));
        this.z80.setR(byArray[25]);
        this.z80.setI(byArray[26]);
        this.z80.setIFF1(byArray[27] != 0);
        this.z80.setIFF2(byArray[28] != 0);
        this.z80.setIX(CPC.getWord(byArray, 29));
        this.z80.setIY(CPC.getWord(byArray, 31));
        this.z80.setSP(CPC.getWord(byArray, 33));
        this.z80.setPC(CPC.getWord(byArray, 35));
        this.z80.setIM(byArray[37]);
        this.z80.setAF1(CPC.getWord(byArray, 38));
        this.z80.setBC1(CPC.getWord(byArray, 40));
        this.z80.setDE1(CPC.getWord(byArray, 42));
        this.z80.setHL1(CPC.getWord(byArray, 44));
        this.gateArray.setSelectedInk(byArray[46]);
        for (n = 0; n < 17; ++n) {
            this.gateArray.setInk(n, byArray[n + 47]);
        }
        this.gateArray.setModeAndROMEnable(memory, byArray[64]);
        memory.setRAMBank(byArray[65]);
        this.crtc.setSelectedRegister(byArray[66]);
        for (n = 0; n < 18; ++n) {
            this.crtc.setRegister(n, byArray[n + 67]);
        }
        this.ppi.setControl(byArray[89] & 0xFF | 0x80);
        this.ppi.setOutputValue(0, byArray[86] & 0xFF);
        this.ppi.setOutputValue(1, byArray[87] & 0xFF);
        n = byArray[88] & 0xFF;
        this.ppi.setOutputValue(2, n);
        this.psg.setBDIR_BC2_BC1(this.PSG_VALUES[n >> 6], this.ppi.readOutput(0));
        this.psg.setSelectedRegister(byArray[90]);
        for (n = 0; n < 14; ++n) {
            this.psg.setRegister(n, byArray[n + 91] & 0xFF);
        }
        n = CPC.getWord(byArray, 107) << 10;
        byte[] byArray2 = memory.getMemory();
        System.arraycopy(byArray, 256, byArray2, 0, n);
        System.arraycopy(byArray, 256, GateArray.screenmemory, 0, 65536);
        this.start();
    }

    public void loadEntry(int n) {
        try {
            if (this.disknames[n].toLowerCase().endsWith("dsk")) {
                this.DSK_Load(this.disknames[n], this.disks[n]);
            }
            if (this.disknames[n].toLowerCase().endsWith("sna")) {
                this.a(this.disks[n]);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void DSK_Load(String object, byte[] byArray) {
        object = new CPCDiscImage((String)object, byArray);
        int n = this.getCurrentDrive();
        this.floppies[n].setSides(((CPCDiscImage)object).getNumberOfSides());
        int n2 = ((CPCDiscImage)object).getNumberOfSides() == 1 ? 1 : 3;
        this.fdc.setDrive(n, this.floppies[n]);
        this.fdc.getDrive(n).setDisc(n2, (DiscImage)object);
        this.reSync();
    }

    public void displayLostFocus() {
        this.keyboard.reset();
    }

    public Drive[] getFloppyDrives() {
        return this.floppies;
    }

    public int PEEK(int n) {
        return memory.readByte(n);
    }

    public void POKE(int n, int n2) {
        memory.writeByte(n, n2);
    }

    public void storeSNA() {
        int n;
        this.z80.stop();
        this.a = new byte[131328];
        try {
            System.arraycopy(SNA_HEADER.getBytes("UTF-8"), 0, this.a, 0, SNA_HEADER.length());
        }
        catch (IOException iOException) {}
        this.a[16] = 1;
        CPC.putWord(this.a, 17, this.z80.getRegisterValue(1));
        CPC.putWord(this.a, 19, this.z80.getRegisterValue(7));
        CPC.putWord(this.a, 21, this.z80.getRegisterValue(5));
        CPC.putWord(this.a, 23, this.z80.getRegisterValue(3));
        this.a[25] = (byte)this.z80.getRegisterValue(14);
        this.a[26] = (byte)this.z80.getRegisterValue(12);
        this.a[27] = (byte)this.z80.getIFF1();
        this.a[28] = (byte)this.z80.getIFF2();
        CPC.putWord(this.a, 29, this.z80.getRegisterValue(9));
        CPC.putWord(this.a, 31, this.z80.getRegisterValue(11));
        CPC.putWord(this.a, 33, this.z80.getRegisterValue(10));
        CPC.putWord(this.a, 35, this.z80.getRegisterValue(13));
        this.a[37] = (byte)this.z80.getIM();
        CPC.putWord(this.a, 38, this.z80.getRegisterValue(2));
        CPC.putWord(this.a, 40, this.z80.getRegisterValue(8));
        CPC.putWord(this.a, 42, this.z80.getRegisterValue(6));
        CPC.putWord(this.a, 44, this.z80.getRegisterValue(4));
        this.a[46] = (byte)this.gateArray.getSelectedInk();
        for (n = 0; n < 17; ++n) {
            this.a[n + 47] = (byte)GateArray.getInks(n);
        }
        this.a[66] = (byte)this.crtc.getSelectedRegister();
        for (n = 0; n < 18; ++n) {
            this.a[n + 67] = (byte)this.crtc.getReg(n);
        }
        this.a[89] = (byte)this.ppi.getControl();
        this.a[86] = (byte)this.ppi.getOutputValue(0);
        this.a[87] = (byte)this.ppi.getOutputValue(1);
        this.a[88] = (byte)this.ppi.getOutputValue(2);
        this.a[90] = (byte)this.psg.getSelectedRegister();
        for (n = 0; n < 16; ++n) {
            this.a[n + 91] = (byte)this.psg.getRegister(n);
        }
        this.a[64] = (byte)this.gateArray.getMode();
        this.a[65] = (byte)(this.gateArray.getRAMBank() & 0x3F);
        this.a[85] = (byte)memory.getUpperROM();
        this.a[107] = -128;
        Object object = memory.getMemory();
        System.arraycopy(object, 0, this.a, 256, 131072);
        try {
            object = new File("output.sna");
            int n2 = 0;
            while (((File)object).exists()) {
                object = new File("output_" + n2++ + ".sna");
            }
            object = new FileOutputStream((File)object);
            ((FileOutputStream)object).write(this.a);
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start();
    }

    public void restoreSNA() {
        if (this.a != null) {
            this.z80.stop();
            this.a(this.a);
            this.start();
        }
    }

    public void CDT_Load(String string, byte[] byArray) {
        this.e = 0;
        tapesample = null;
        System.gc();
        this.a.set(byArray, 44100);
        try {
            tapesample = this.a.convert();
        }
        catch (Exception exception) {
            tapesample = null;
        }
        if (tapesample == null) {
            tapesample = new byte[0];
        }
        this.f = 24;
        tapePosition = 0;
        this.c = true;
    }

    public void TapeRelayCheck(int n) {
        this.b = n;
        if (n == 16 && !this.a) {
            this.a = true;
            System.out.println("Tape relay on... ");
        }
        if ((n & 0x10) == 0 && this.a) {
            this.b = true;
            this.c = 1;
            return;
        }
        this.b = false;
        this.c = 0;
    }

    public void StopTape() {
        this.a = false;
        this.b = false;
        System.out.println("Tape relay off... ");
    }

    public void tapeCycle() {
        ++this.e;
        if (this.e > 2000000) {
            this.e = 2000000;
            ++this.d;
            if (this.d > this.f) {
                this.d = 0;
                if (tapePosition >= tapesample.length - 4) {
                    this.c = false;
                    tapePosition = 0;
                    this.e = 0;
                    return;
                }
                this.g = tapesample[tapePosition];
                ++tapePosition;
                this.g = 128 - this.g;
                this.h = 16 * this.g / 128;
                Display.ledOn = this.g == 0;
                AY_3_8910.digicount = 10;
                AY_3_8910.digiblast = this.psg.readRegister(7) == 63 && (this.psg.readRegister(8) == 0 || this.psg.readRegister(9) == 0 || this.psg.readRegister(10) == 0);
                AY_3_8910.blasterA = AY_3_8910.blasterB = this.h;
            }
        }
    }

    public void CSWLoad(String string, byte[] byArray) {
        int n;
        tapesample = null;
        System.gc();
        this.e = 0;
        int n2 = byArray.length;
        int n3 = CPC.getWord(byArray, 25);
        if (byArray[27] != 1) {
            return;
        }
        int n4 = 127 + byArray[28] % 2;
        boolean bl = (byArray[28] + 2) % 2 == 0;
        this.f = 1010000 / n3;
        n3 = 0;
        int n5 = 32;
        while (n5 < n2) {
            if ((n = byArray[n5++] & 0xFF) == 0) {
                n = byArray[n5++] + (byArray[n5++] << 8) + (byArray[n5++] << 16) + (byArray[n5++] << 24);
            }
            while (n-- > 0) {
                ++n3;
            }
        }
        tapesample = new byte[n3 + 1];
        n = 0;
        n5 = 32;
        while (n5 < n2) {
            if ((n3 = byArray[n5++] & 0xFF) == 0) {
                n3 = byArray[n5++] + (byArray[n5++] << 8) + (byArray[n5++] << 16) + (byArray[n5++] << 24);
            }
            if (!bl) {
                n4 = 255 - n4;
            }
            while (n3-- > 0) {
                CPC.tapesample[n] = (byte)(n4 ^ 0x80);
                CPC.tapesample[n] = tapesample[n] == 0 ? -38 : 38;
                ++n;
            }
            if (!bl) continue;
            n4 = 255 - n4;
        }
        this.c = true;
    }
}

