/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc;

import JCPC.core.device.Device;
import JCPC.core.device.floppy.DiscImage;
import JCPC.core.device.floppy.UPD765A;
import JCPC.system.cpc.CPCDiscImageSector;
import JCPC.system.cpc.CPCDiscImageTrack;
import JCPC.system.cpc.GateArray;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CPCDiscImage
extends DiscImage {
    private static final int[] a = new int[]{193, 195, 197, 199, 201, 194, 196, 198, 200};
    private final String a;
    private final String b;
    private final int a;
    private final int b;
    private final int c;
    private final boolean a;
    private final CPCDiscImageTrack[][] a;
    public String toname;

    public static CPCDiscImage create(String string, InputStream inputStream) {
        return new CPCDiscImage(string, CPCDiscImage.a(inputStream));
    }

    public CPCDiscImage(String string, int n) {
        super(string);
        this.toname = string;
        this.a = "EXTENDED CPC DSK File\r\nDisk-Info\r\n";
        this.b = "JAVACPC EXTDSK";
        this.a = 80;
        this.b = 1;
        this.c = Math.max(1, Math.min(2, n));
        this.a = true;
        this.a = new CPCDiscImageTrack[this.a][this.b];
        int n2 = UPD765A.getCommandSize(512);
        for (n = 0; n < this.a; ++n) {
            for (int i = 0; i < this.b; ++i) {
                this.a[n][i] = new CPCDiscImageTrack(n, i, 4608, 9);
                for (int j = 0; j < 9; ++j) {
                    byte[] byArray = new byte[512];
                    for (int k = 0; k < byArray.length; ++k) {
                        byArray[k] = 0;
                    }
                    this.a[n][i].setSector(new CPCDiscImageSector(n, i, a[j], n2, byArray), j);
                }
            }
        }
    }

    public CPCDiscImage(String string, byte[] byArray) {
        super(string);
        this.toname = string;
        this.a = new String(byArray, 0, 34);
        this.b = new String(byArray, 34, 14);
        this.a = byArray[48] & 0xFF;
        this.b = byArray[49] & 0xFF;
        this.c = Device.getWord(byArray, 50);
        this.a = this.a.toUpperCase().startsWith("EXTENDED");
        boolean bl = this.a || this.a.toUpperCase().startsWith("MV - CPC");
        boolean bl2 = this.b.equalsIgnoreCase("Win APE 32 1.0");
        this.a = new CPCDiscImageTrack[this.a][this.b];
        if (bl) {
            byte[] byArray2 = new byte[256];
            if (this.a) {
                System.arraycopy(byArray, 52, byArray2, 0, this.a * this.b);
            }
            int n = 256;
            for (int i = 0; i < this.a; ++i) {
                for (int j = 0; j < this.b; ++j) {
                    int n2 = this.c;
                    if (this.a) {
                        n2 = (byArray2[i * this.b + j] & 0xFF) << 8;
                    }
                    if (n2 == 0 || n >= byArray.length) continue;
                    int n3 = n;
                    int n4 = byArray[n + 21] & 0xFF;
                    int n5 = n + 24;
                    this.a[i][j] = new CPCDiscImageTrack(i, j, n2, n4);
                    n += 256;
                    for (int k = 0; k < n4; ++k) {
                        int n6;
                        int n7 = byArray[n5++] & 0xFF;
                        int n8 = byArray[n5++] & 0xFF;
                        int n9 = byArray[n5++] & 0xFF;
                        int n10 = byArray[n5++] & 0xFF;
                        int n11 = UPD765A.getSectorSize(n10);
                        if (this.a && !bl2 && (n6 = Device.getWord(byArray, n5 += 2)) != 0) {
                            n11 = n6;
                            n10 = UPD765A.getCommandSize(n11);
                        }
                        n5 += 2;
                        byte[] byArray3 = new byte[n11];
                        try {
                            System.arraycopy(byArray, n, byArray3, 0, n11);
                        }
                        catch (Exception exception) {
                            System.err.println("Corrupt diskimage loaded..." + n11);
                            for (int i2 = 0; i2 < n11; ++i2) {
                                byArray3[i2] = -27;
                            }
                        }
                        n += n11;
                        this.a[i][j].setSector(new CPCDiscImageSector(n7, n8, n9, n10, byArray3), k);
                    }
                    if (bl2) continue;
                    n = n3 + n2;
                }
            }
        }
    }

    public CPCDiscImage(String string, CPCDiscImage object, CPCDiscImage cPCDiscImage) {
        super(string);
        int n;
        this.a = ((CPCDiscImage)object).a;
        this.b = ((CPCDiscImage)object).b;
        this.a = Math.max(((CPCDiscImage)object).a, cPCDiscImage.a);
        this.b = 2;
        this.c = ((CPCDiscImage)object).c;
        this.a = ((CPCDiscImage)object).a;
        if (!((CPCDiscImage)object).a || !cPCDiscImage.a) {
            throw new IOException("only extended images can be merged!");
        }
        if (((CPCDiscImage)object).b != 1 || cPCDiscImage.b != 1) {
            throw new IOException("only single sided extended images can be merged!");
        }
        this.a = new CPCDiscImageTrack[this.a][this.b];
        for (n = 0; n < ((CPCDiscImage)object).a; ++n) {
            this.a[n][0] = ((CPCDiscImage)object).a[n][0];
        }
        for (n = 0; n < cPCDiscImage.a; ++n) {
            object = cPCDiscImage.a[n][0];
            ((CPCDiscImageTrack)object).setSide(1);
            this.a[n][1] = object;
        }
    }

    public byte[] readSector(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n <= 79) {
            try {
                return this.a[n][n2 & 1].getSectorData(n3, n4, n5, n6);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public synchronized void saveImage() {
        if (this.toname == null || !GateArray.cpc.saveallowed) {
            return;
        }
        Object object = new File(this.toname);
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkWrite(((File)object).getAbsolutePath());
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        this.name = ((File)object).getAbsolutePath();
        if (!this.name.toLowerCase().endsWith(".dsk")) {
            this.name = this.name + ".dsk";
        }
        try {
            int n;
            int n2;
            int n3;
            object = new BufferedOutputStream(new FileOutputStream(this.name));
            ((FilterOutputStream)object).write("EXTENDED CPC DSK File\r\nDisk-Info\r\n".getBytes("UTF-8"));
            ((FilterOutputStream)object).write("JAVACPC EXTDSK".getBytes("UTF-8"));
            ((BufferedOutputStream)object).write(this.a);
            ((BufferedOutputStream)object).write(this.b);
            ((BufferedOutputStream)object).write(0);
            ((BufferedOutputStream)object).write(0);
            for (n3 = 0; n3 < this.a; ++n3) {
                for (n2 = 0; n2 < this.b; ++n2) {
                    try {
                        n = this.a[n3][n2].getLength();
                        ((BufferedOutputStream)object).write(n / 256 & 0xFF);
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            n3 = 204 - this.a * this.b;
            for (n2 = 0; n2 < n3; ++n2) {
                ((BufferedOutputStream)object).write(0);
            }
            for (n2 = 0; n2 < this.a; ++n2) {
                for (n = 0; n < this.b; ++n) {
                    int n4;
                    CPCDiscImageTrack cPCDiscImageTrack = this.a[n2][n];
                    ((FilterOutputStream)object).write("Track-Info\r\n".getBytes("UTF-8"));
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(cPCDiscImageTrack.getTrack());
                    ((BufferedOutputStream)object).write(cPCDiscImageTrack.getSide());
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(0);
                    ((BufferedOutputStream)object).write(cPCDiscImageTrack.getSector(0).getSize());
                    int n5 = cPCDiscImageTrack.getSectorCount();
                    ((BufferedOutputStream)object).write(n5);
                    ((BufferedOutputStream)object).write(78);
                    ((BufferedOutputStream)object).write(229);
                    for (n4 = 0; n4 < n5; ++n4) {
                        CPCDiscImageSector cPCDiscImageSector = cPCDiscImageTrack.getSector(n4);
                        ((BufferedOutputStream)object).write(cPCDiscImageSector.getTrack());
                        ((BufferedOutputStream)object).write(cPCDiscImageSector.getSide());
                        ((BufferedOutputStream)object).write(cPCDiscImageSector.getId());
                        ((BufferedOutputStream)object).write(cPCDiscImageSector.getSize());
                        ((BufferedOutputStream)object).write(0);
                        ((BufferedOutputStream)object).write(0);
                        n3 = cPCDiscImageSector.getData().length;
                        ((BufferedOutputStream)object).write(n3 & 0xFF);
                        ((BufferedOutputStream)object).write(n3 / 256 & 0xFF);
                    }
                    n3 = 232 - n5 * 8;
                    for (n4 = 0; n4 < n3; ++n4) {
                        ((BufferedOutputStream)object).write(0);
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        ((FilterOutputStream)object).write(cPCDiscImageTrack.getSector(n4).getData());
                    }
                }
            }
            ((FilterOutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public int[] getSectorID(int n, int n2, int n3) {
        return this.a[n][n2 & 1].getSectorIDs(n3);
    }

    public int getSectorCount(int n, int n2) {
        int n3 = 0;
        try {
            n3 = n > 79 ? 0 : this.a[n][n2 & 1].getSectorCount();
        }
        catch (Exception exception) {}
        return n3;
    }

    public void writeSector(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
    }

    public String getDiscId() {
        return this.a;
    }

    public String getCreator() {
        return this.b;
    }

    public int getNumberOfTracks() {
        return this.a;
    }

    public int getNumberOfSides() {
        return this.b;
    }

    public int getSizeOfTrack() {
        return this.c;
    }

    public boolean isExtended() {
        return this.a;
    }

    public CPCDiscImageTrack[][] getTracks() {
        return this.a;
    }

    private static byte[] a(InputStream inputStream) {
        int n;
        if (inputStream == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[8192];
        int n2 = 0;
        int n3 = 16384;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            if ((n2 += n) != byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length + n3];
            if (n3 < 0x100000) {
                n3 <<= 1;
            }
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        inputStream.close();
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }
}

