/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.cartridge;

import com.lambelly.lambnes.platform.Config;
import java.io.File;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CartridgeLocator {
    private Vector<File> roms = new Vector();
    private Logger logger = Logger.getLogger(CartridgeLocator.class);

    public CartridgeLocator() {
        this.generateListOfDefaultRoms(Config.getDefaultRomLocation());
    }

    public CartridgeLocator(String secondaryPath) {
        this.generateListOfDefaultRoms(secondaryPath);
    }

    public File locateCartridge() {
        if (this.getRoms().size() > 1) {
            return this.getRoms().get(this.selectRom());
        }
        if (this.getRoms().size() == 1) {
            return this.getRoms().get(0);
        }
        return null;
    }

    private int selectRom() {
        System.out.println("multiple cartridges exist in the default location.");
        System.out.println("please select a cartridge to load: ");
        Iterator<File> it = this.getRoms().iterator();
        int i = 0;
        while (it.hasNext()) {
            System.out.println(String.valueOf(i) + "." + it.next().getName());
            ++i;
        }
        Scanner sc = new Scanner(System.in);
        int select = sc.nextInt();
        if (select >= 0 && select < this.getRoms().size()) {
            return select;
        }
        return this.selectRom();
    }

    private void generateListOfDefaultRoms(String path) {
        File dir = new File(path);
        File[] children = dir.listFiles();
        if (children == null) {
            if (dir.isFile() && dir.getName().toLowerCase().endsWith(".zip")) {
                this.addRom(dir);
            }
        } else {
            int i = 0;
            while (i < children.length) {
                File file = children[i];
                if (file.getName().toLowerCase().endsWith(".zip")) {
                    this.addRom(file);
                } else {
                    this.logger.debug((Object)("not adding file: " + file.getName()));
                }
                ++i;
            }
        }
    }

    public void addRom(File rom) {
        this.roms.add(rom);
    }

    public Vector<File> getRoms() {
        return this.roms;
    }

    public void setRoms(Vector<File> roms) {
        this.roms = roms;
    }
}

