/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.gui;

import com.lambelly.lambnes.gui.LambNesAudioBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;

public class LambNesAudio {
    private Logger logger = Logger.getLogger(LambNesAudio.class);
    private boolean soundEnabled = false;
    private SourceDataLine sourceDataLine = null;
    private LambNesAudioBuffer audioDataBuffer = null;

    public LambNesAudio(int sampleRate) {
        this.setAudioDataBuffer(new LambNesAudioBuffer(sampleRate));
        AudioFormat format = new AudioFormat(sampleRate, 16, 1, true, false);
        int samplesPerFrame = (int)Math.ceil((double)(sampleRate * 2) / 60.0);
        try {
            this.setSourceDataLine(AudioSystem.getSourceDataLine(format));
            this.getSourceDataLine().open(format, samplesPerFrame * 8);
            this.getSourceDataLine().start();
        }
        catch (Exception e) {
            this.logger.error((Object)"unable to open audio source data line");
        }
    }

    public void outputFrame() {
        if (this.isSoundEnabled()) {
            this.getSourceDataLine().write(this.getAudioDataBuffer().getBuffer(), 0, this.getAudioDataBuffer().getBufferPointer());
        }
        this.getAudioDataBuffer().reset();
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public void setSoundEnabled(boolean soundEnabled) {
        this.soundEnabled = soundEnabled;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public void setSourceDataLine(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
    }

    public LambNesAudioBuffer getAudioDataBuffer() {
        return this.audioDataBuffer;
    }

    public void setAudioDataBuffer(LambNesAudioBuffer audioDataBuffer) {
        this.audioDataBuffer = audioDataBuffer;
    }
}

