/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.gui;

import com.lambelly.lambnes.LambNes;
import com.lambelly.lambnes.gui.LambNesKeyListener;
import com.lambelly.lambnes.gui.Screen;
import com.lambelly.lambnes.platform.Platform;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class LambNesGui
extends JFrame
implements Runnable {
    private static Screen screen = new Screen();
    private static Container content = null;
    private static boolean run = true;
    private Timer workertimer = null;
    private static Logger logger = Logger.getLogger(LambNesGui.class);
    public static final int SLEEP_TIME = 125;
    public static final int WORKER_INTIAL_DELAY = 10000;
    public static final int WORKER_PAUSE = 100000;
    public static final String SCREEN_TITLE = "LambNes";
    public static final String SPRITE_PATTERN_TABLE_TOOL_TIP_TEXT = "Sprite Pattern Table";
    public static final String BACKGROUND_PATTERN_TABLE_TOOL_TIP_TEXT = "Background Pattern Table";
    private static final boolean SPRITE_PATTERN_TABLE_VISUALIZATION = true;
    private static final boolean BACKGROUND_PATTERN_TABLE_VISUALIZATION = true;
    private static final boolean SPRITE_PALETTE_VISUALIZATION = true;
    private static final boolean BACKGROUND_PALETTE_VISUALIZATION = true;
    private static final boolean MASTER_PALETTE_VISUALIZATION = true;

    public LambNesGui() {
        this.setTitle(SCREEN_TITLE);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"window closed.");
                }
                LambNesGui.this.setVisible(false);
                LambNes.getPlatform().setRun(false);
                LambNesGui.this.dispose();
            }
        });
        this.addKeyListener(new LambNesKeyListener());
        LambNesGui.setContent(this.getContentPane());
        LambNesGui.getContent().setLayout(new GridLayout(1, 1));
        LambNesGui.getContent().add(LambNesGui.getScreen());
        this.pack();
        ActionListener workerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LambNesGui.this.getWorkertimer().restart();
            }
        };
        this.setWorkertimer(new Timer(100000, workerActionListener));
        this.getWorkertimer().setInitialDelay(10000);
        this.getWorkertimer().start();
    }

    @Override
    public void run() {
        try {
            try {
                Platform p = LambNes.getPlatform();
                while (p.isRun()) {
                    Thread.sleep(125L);
                    content.repaint();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.setVisible(false);
                this.dispose();
            }
        }
        finally {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void pushErrorMessage(String message) {
        logger.error((Object)message);
        JOptionPane.showMessageDialog(null, message, "error", 0);
    }

    public static Screen getScreen() {
        return screen;
    }

    public static void setScreen(Screen s) {
        screen = s;
    }

    public static boolean isRun() {
        return run;
    }

    public static void setRun(boolean run) {
        LambNesGui.run = run;
    }

    public static boolean isSpritePatternTableVisualization() {
        return true;
    }

    public static boolean isBackgroundPatternTableVisualization() {
        return true;
    }

    public static boolean isSpritePaletteVisualization() {
        return true;
    }

    public static boolean isBackgroundPaletteVisualization() {
        return true;
    }

    public static boolean isMasterPaletteVisualization() {
        return true;
    }

    public static Container getContent() {
        return content;
    }

    public static void setContent(Container content) {
        LambNesGui.content = content;
    }

    public Timer getWorkertimer() {
        return this.workertimer;
    }

    public void setWorkertimer(Timer workertimer) {
        this.workertimer = workertimer;
    }
}

