/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.gui;

import com.lambelly.lambnes.gui.PatternTableIcon;
import com.lambelly.lambnes.gui.PatternTableLabel;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PatternTableVisualization
extends JPanel {
    private Logger logger = Logger.getLogger(PatternTableVisualization.class);
    private PatternTableIcon[] patternTableIcons = new PatternTableIcon[256];
    private int patternTableVisualizationType = 0;
    public static final int PATTERN_TABLE_VISUALIZATION_SPRITE = 0;
    public static final int PATTERN_TABLE_VISUALIZATION_IMAGE = 1;
    public static final int SCREEN_HORIZONTAL_RESOLUTION = 256;
    public static final int SCREEN_VERTICAL_RESOLUTION = 240;

    public PatternTableVisualization(String toolTipText, int patternTableVisualizationSelect) {
        super(new GridLayout(16, 16));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"initializing");
        }
        this.setBounds(0, 0, 256, 240);
        this.setPreferredSize(new Dimension(256, 240));
        this.setToolTipText(toolTipText);
        this.setPatternTableVisualizationType(patternTableVisualizationSelect);
        int x = 0;
        while (x < 256) {
            PatternTableIcon i = new PatternTableIcon(x);
            this.setPatternTableIcon(x, i);
            this.add(new PatternTableLabel(x, i));
            ++x;
        }
    }

    public PatternTableIcon[] getPatternTableIcons() {
        return this.patternTableIcons;
    }

    public PatternTableIcon getPatternTableIcon(int index) {
        return this.patternTableIcons[index];
    }

    public void setPatternTableIcons(PatternTableIcon[] patternTableIcons) {
        this.patternTableIcons = patternTableIcons;
    }

    public void setPatternTableIcon(int index, PatternTableIcon icon) {
        this.patternTableIcons[index] = icon;
    }

    public int getPatternTableVisualizationType() {
        return this.patternTableVisualizationType;
    }

    public void setPatternTableVisualizationType(int patternTableVisualizationType) {
        this.patternTableVisualizationType = patternTableVisualizationType;
    }
}

