/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.controllers;

import com.lambelly.lambnes.platform.controllers.NesController;
import org.apache.log4j.Logger;

public class NesJoypad
implements NesController {
    public static final int CONTROLLER_1_SIGNATURE = 1;
    public static final int CONTROLLER_2_SIGNATURE = 2;
    private boolean a = false;
    private boolean b = false;
    private boolean start = false;
    private boolean select = false;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;
    private int controllerNumber = 0;
    private Integer rawControlByte = 0;
    private Logger logger = Logger.getLogger(NesJoypad.class);

    public NesJoypad(int controllerNumber) {
        this.setControllerNumber(controllerNumber);
    }

    @Override
    public int read(int bit) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("read " + bit));
            this.logger.debug((Object)("controller number: " + this.getControllerNumber()));
        }
        if (bit == 0) {
            return this.isA() ? 1 : 0;
        }
        if (bit == 1) {
            return this.isB() ? 1 : 0;
        }
        if (bit == 2) {
            return this.isSelect() ? 1 : 0;
        }
        if (bit == 3) {
            return this.isStart() ? 1 : 0;
        }
        if (bit == 4) {
            return this.isUp() ? 1 : 0;
        }
        if (bit == 5) {
            return this.isDown() ? 1 : 0;
        }
        if (bit == 6) {
            return this.isLeft() ? 1 : 0;
        }
        if (bit == 7) {
            return this.isRight() ? 1 : 0;
        }
        if (bit >= 8 && bit <= 15) {
            return 0;
        }
        if (bit >= 16 && bit <= 17) {
            return 0;
        }
        if (bit == 18) {
            if (this.getControllerNumber() == 2) {
                return 1;
            }
            return 0;
        }
        if (bit == 19) {
            if (this.getControllerNumber() == 1) {
                return 1;
            }
            return 0;
        }
        if (bit >= 20 && bit <= 23) {
            return 0;
        }
        throw new IllegalStateException("tried to read bit " + bit + " from controller");
    }

    @Override
    public boolean isA() {
        return this.a;
    }

    @Override
    public void setA(boolean a) {
        this.a = a;
    }

    @Override
    public boolean isB() {
        return this.b;
    }

    @Override
    public void setB(boolean b) {
        this.b = b;
    }

    @Override
    public boolean isStart() {
        return this.start;
    }

    @Override
    public void setStart(boolean start) {
        this.start = start;
    }

    @Override
    public boolean isSelect() {
        return this.select;
    }

    @Override
    public void setSelect(boolean select) {
        this.select = select;
    }

    @Override
    public boolean isUp() {
        return this.up;
    }

    @Override
    public void setUp(boolean up) {
        this.up = up;
    }

    @Override
    public boolean isDown() {
        return this.down;
    }

    @Override
    public void setDown(boolean down) {
        this.down = down;
    }

    @Override
    public boolean isLeft() {
        return this.left;
    }

    @Override
    public void setLeft(boolean left) {
        this.left = left;
    }

    @Override
    public boolean isRight() {
        return this.right;
    }

    @Override
    public void setRight(boolean right) {
        this.right = right;
    }

    public int getControllerNumber() {
        return this.controllerNumber;
    }

    public void setControllerNumber(int controllerNumber) {
        this.controllerNumber = controllerNumber;
    }

    public Integer getRawControlByte() {
        return this.rawControlByte;
    }

    public void setRawControlByte(Integer rawControlByte) {
        this.rawControlByte = rawControlByte;
    }
}

