/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.cpu;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Instruction {
    ADC_IMMEDIATE(105, 2, 2),
    ADC_ZERO_PAGE(101, 2, 3),
    ADC_ZERO_PAGE_X(117, 2, 4),
    ADC_ABSOLUTE(109, 3, 4),
    ADC_ABSOLUTE_X(125, 3, 4),
    ADC_ABSOLUTE_Y(121, 3, 4),
    ADC_INDEXED_INDIRECT(97, 2, 6),
    ADC_INDIRECT_INDEXED(113, 2, 5),
    AND_IMMEDIATE(41, 2, 2),
    AND_ZERO_PAGE(37, 2, 3),
    AND_ZERO_PAGE_X(53, 2, 4),
    AND_ABSOLUTE(45, 3, 4),
    AND_ABSOLUTE_X(61, 3, 4),
    AND_ABSOLUTE_Y(57, 3, 4),
    AND_INDEXED_INDIRECT(33, 2, 6),
    AND_INDIRECT_INDEXED(49, 2, 5),
    ASL_ACCUMULATOR(10, 1, 2),
    ASL_ZERO_PAGE(6, 2, 5),
    ASL_ZERO_PAGE_X(22, 2, 6),
    ASL_ABSOLUTE(14, 3, 6),
    ASL_ABSOLUTE_X(30, 3, 7),
    BCC(144, 2, 2),
    BCS(176, 2, 2),
    BEQ(240, 2, 2),
    BIT_ZERO_PAGE(36, 2, 3),
    BIT_ABSOLUTE(44, 3, 4),
    BMI(48, 2, 2),
    BNE(208, 2, 2),
    BPL(16, 2, 2),
    BRK(0, 1, 7),
    BVC(80, 2, 2),
    BVS(112, 2, 2),
    CLC(24, 1, 2),
    CLD(216, 1, 2),
    CLI(88, 1, 2),
    CLV(184, 1, 2),
    CMP_IMMEDIATE(201, 2, 2),
    CMP_ZERO_PAGE(197, 2, 3),
    CMP_ZERO_PAGE_X(213, 2, 4),
    CMP_ABSOLUTE(205, 3, 4),
    CMP_ABSOLUTE_X(221, 3, 4),
    CMP_ABSOLUTE_Y(217, 3, 4),
    CMP_INDEXED_INDIRECT(193, 2, 6),
    CMP_INDIRECT_INDEXED(209, 2, 5),
    CPX_IMMEDIATE(224, 2, 2),
    CPX_ZERO_PAGE(228, 2, 3),
    CPX_ABSOLUTE(236, 3, 4),
    CPY_IMMEDIATE(192, 2, 2),
    CPY_ZERO_PAGE(196, 2, 3),
    CPY_ABSOLUTE(204, 3, 4),
    DEC_ZERO_PAGE(198, 2, 5),
    DEC_ZERO_PAGE_X(214, 2, 6),
    DEC_ABSOLUTE(206, 3, 6),
    DEC_ABSOLUTE_X(222, 3, 7),
    DEX(202, 1, 2),
    DEY(136, 1, 2),
    EOR_IMMEDIATE(73, 2, 2),
    EOR_ZERO_PAGE(69, 2, 3),
    EOR_ZERO_PAGE_X(85, 2, 4),
    EOR_ABSOLUTE(77, 3, 4),
    EOR_ABSOLUTE_X(93, 3, 4),
    EOR_ABSOLUTE_Y(89, 3, 4),
    EOR_INDEXED_INDIRECT(65, 2, 6),
    EOR_INDIRECT_INDEXED(81, 2, 5),
    INC_ZERO_PAGE(230, 2, 5),
    INC_ZERO_PAGE_X(246, 2, 6),
    INC_ABSOLUTE(238, 3, 6),
    INC_ABSOLUTE_X(254, 3, 7),
    INX(232, 1, 2),
    INY(200, 1, 2),
    JMP_ABSOLUTE(76, 3, 3),
    JMP_RELATIVE(108, 3, 5),
    JSR_ABSOLUTE(32, 3, 6),
    LDA_IMMEDIATE(169, 2, 2),
    LDA_ZERO_PAGE(165, 2, 3),
    LDA_ZERO_PAGE_X(181, 2, 4),
    LDA_ABSOLUTE(173, 3, 4),
    LDA_ABSOLUTE_X(189, 3, 4),
    LDA_ABSOLUTE_Y(185, 3, 4),
    LDA_INDEXED_INDIRECT(161, 2, 6),
    LDA_INDIRECT_INDEXED(177, 2, 5),
    LDX_IMMEDIATE(162, 2, 2),
    LDX_ZERO_PAGE(166, 2, 3),
    LDX_ZERO_PAGE_Y(182, 2, 4),
    LDX_ABSOLUTE(174, 3, 4),
    LDX_ABSOLUTE_Y(190, 3, 4),
    LDY_IMMEDIATE(160, 2, 2),
    LDY_ZERO_PAGE(164, 2, 3),
    LDY_ZERO_PAGE_X(180, 2, 4),
    LDY_ABSOLUTE(172, 3, 4),
    LDY_ABSOLUTE_X(188, 3, 4),
    LSR_ACCUMULATOR(74, 1, 2),
    LSR_ZERO_PAGE(70, 2, 5),
    LSR_ZERO_PAGE_X(86, 2, 6),
    LSR_ABSOLUTE(78, 3, 6),
    LSR_ABSOLUTE_X(94, 3, 7),
    NOP(234, 1, 2),
    ORA_IMMEDIATE(9, 2, 2),
    ORA_ZERO_PAGE(5, 2, 3),
    ORA_ZERO_PAGE_X(21, 2, 4),
    ORA_ABSOLUTE(13, 3, 4),
    ORA_ABSOLUTE_X(29, 3, 4),
    ORA_ABSOLUTE_Y(25, 3, 4),
    ORA_INDEXED_INDIRECT(1, 2, 6),
    ORA_INDIRECT_INDEXED(17, 2, 5),
    PHA(72, 1, 3),
    PHP(8, 1, 3),
    PLA(104, 1, 4),
    PLP(40, 1, 4),
    ROL_ACCUMULATOR(42, 1, 2),
    ROL_ZERO_PAGE(38, 2, 5),
    ROL_ZERO_PAGE_X(54, 2, 6),
    ROL_ABSOLUTE(46, 3, 6),
    ROL_ABSOLUTE_X(62, 3, 7),
    ROR_ACCUMULATOR(106, 1, 2),
    ROR_ZERO_PAGE(102, 2, 5),
    ROR_ZERO_PAGE_X(118, 2, 6),
    ROR_ABSOLUTE(110, 3, 6),
    ROR_ABSOLUTE_X(126, 3, 7),
    RTI(64, 1, 6),
    RTS(96, 1, 6),
    SBC_IMMEDIATE(233, 2, 2),
    SBC_ZERO_PAGE(229, 2, 3),
    SBC_ZERO_PAGE_X(245, 2, 4),
    SBC_ABSOLUTE(237, 3, 4),
    SBC_ABSOLUTE_X(253, 3, 4),
    SBC_ABSOLUTE_Y(249, 3, 4),
    SBC_INDEXED_INDIRECT(225, 2, 6),
    SBC_INDIRECT_INDEXED(241, 2, 5),
    SEC(56, 1, 2),
    SED(248, 1, 2),
    SEI(120, 1, 2),
    STA_ZERO_PAGE(133, 2, 3),
    STA_ZERO_PAGE_X(149, 2, 4),
    STA_ABSOLUTE(141, 3, 4),
    STA_ABSOLUTE_X(157, 3, 5),
    STA_ABSOLUTE_Y(153, 3, 5),
    STA_INDEXED_INDIRECT(129, 2, 6),
    STA_INDIRECT_INDEXED(145, 2, 6),
    STX_ZERO_PAGE(134, 2, 3),
    STX_ZERO_PAGE_Y(150, 2, 4),
    STX_ABSOLUTE(142, 3, 4),
    STY_ZERO_PAGE(132, 2, 3),
    STY_ZERO_PAGE_X(148, 2, 4),
    STY_ABSOLUTE(140, 3, 4),
    TAX(170, 1, 2),
    TAY(168, 1, 2),
    TSX(186, 1, 2),
    TXA(138, 1, 2),
    TXS(154, 1, 2),
    TYA(152, 1, 2),
    TOP_ABSOLUTE(12, 3, 4),
    TOP_ABSOLUTE_X_0(28, 3, 4),
    TOP_ABSOLUTE_X_1(60, 3, 4),
    TOP_ABSOLUTE_X_2(92, 3, 4),
    TOP_ABSOLUTE_X_3(124, 3, 4),
    TOP_ABSOLUTE_X_4(220, 3, 4),
    TOP_ABSOLUTE_X_5(252, 3, 4);

    private static final Map<Integer, Instruction> lookup;
    private int opCode = 0;
    private int cycles = 0;
    private int bytes = 0;

    static {
        lookup = new HashMap<Integer, Instruction>();
        for (Instruction i : EnumSet.allOf(Instruction.class)) {
            lookup.put(i.getOpCode(), i);
        }
    }

    private Instruction(int opCode) {
        this.setOpCode(opCode);
    }

    private Instruction(int opCode, int bytes, int cycle) {
        this.setOpCode(opCode);
        this.setCycles(cycle);
        this.setBytes(bytes);
    }

    public static Instruction get(int opCode) {
        return lookup.get(opCode);
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public int getBytes() {
        return this.bytes;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }
}

