/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.cpu;

import com.lambelly.lambnes.platform.cpu.CentralProcessingUnit;
import com.lambelly.lambnes.platform.cpu.Flags;
import com.lambelly.lambnes.platform.cpu.Instruction;
import com.lambelly.lambnes.platform.cpu.NesCpuAddressingModes;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.cpu.NesFlags;
import com.lambelly.lambnes.util.BitUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class NesCpu
implements CentralProcessingUnit {
    NesFlags flags = new NesFlags();
    private int x = 0;
    private int y = 0;
    private int accumulator = 0;
    private NesCpuMemory cpuMemory;
    private NesCpuAddressingModes addressing;
    private Logger logger = Logger.getLogger(NesCpu.class);

    @Override
    public int processNextInstruction() throws IOException {
        int instCode = this.cpuMemory.getNextPrgRomByte();
        Instruction instruction = Instruction.get(instCode);
        if (instruction == null) {
            throw new IllegalStateException("no instruction found for code: " + instCode);
        }
        int value = 0;
        int address = 0;
        int x = 0;
        int y = 0;
        switch (instruction.getOpCode()) {
            case 105: {
                value = this.addressing.getImmediateValue();
                this.doADC(value);
                break;
            }
            case 101: {
                value = this.addressing.getZeroPageValue();
                this.doADC(value);
                break;
            }
            case 117: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doADC(value);
                break;
            }
            case 109: {
                value = this.addressing.getAbsoluteValue();
                this.doADC(value);
                break;
            }
            case 125: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doADC(value);
                break;
            }
            case 121: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doADC(value);
                break;
            }
            case 97: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doADC(value);
                break;
            }
            case 113: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doADC(value);
                break;
            }
            case 41: {
                value = this.addressing.getImmediateValue();
                this.doAND(value);
                break;
            }
            case 37: {
                value = this.addressing.getZeroPageValue();
                this.doAND(value);
                break;
            }
            case 53: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doAND(value);
                break;
            }
            case 45: {
                value = this.addressing.getAbsoluteValue();
                this.doAND(value);
                break;
            }
            case 61: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doAND(value);
                break;
            }
            case 57: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doAND(value);
                break;
            }
            case 33: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doAND(value);
                break;
            }
            case 49: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doAND(value);
                break;
            }
            case 10: {
                value = this.getAccumulator();
                value = this.doASL(value);
                this.setAccumulator(value);
                break;
            }
            case 6: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doASL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 22: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doASL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 14: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doASL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 30: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doASL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 144: {
                address = this.addressing.getRelativeAddress();
                if (this.getFlags().isCarry()) break;
                this.doBranch(address);
                break;
            }
            case 176: {
                address = this.addressing.getRelativeAddress();
                if (!this.getFlags().isCarry()) break;
                this.doBranch(address);
                break;
            }
            case 240: {
                address = this.addressing.getRelativeAddress();
                if (!this.getFlags().isZero()) break;
                this.doBranch(address);
                break;
            }
            case 36: {
                value = this.addressing.getZeroPageValue();
                this.doBIT(value);
                break;
            }
            case 44: {
                value = this.addressing.getAbsoluteValue();
                this.doBIT(value);
                break;
            }
            case 48: {
                address = this.addressing.getRelativeAddress();
                if (!this.getFlags().isNegative()) break;
                this.doBranch(address);
                break;
            }
            case 208: {
                address = this.addressing.getRelativeAddress();
                if (this.getFlags().isZero()) break;
                this.doBranch(address);
                break;
            }
            case 16: {
                address = this.addressing.getRelativeAddress();
                if (this.getFlags().isNegative()) break;
                this.doBranch(address);
                break;
            }
            case 0: {
                this.pushStatus(true);
                break;
            }
            case 80: {
                address = this.addressing.getRelativeAddress();
                if (this.getFlags().isOverflow()) break;
                this.doBranch(address);
                break;
            }
            case 112: {
                address = this.addressing.getRelativeAddress();
                if (!this.getFlags().isOverflow()) break;
                this.doBranch(address);
                break;
            }
            case 24: {
                this.getFlags().setCarry(false);
                break;
            }
            case 216: {
                this.getFlags().setDecimalMode(false);
                break;
            }
            case 88: {
                this.getFlags().setIrqDisable(false);
                break;
            }
            case 184: {
                this.getFlags().setOverflow(false);
                break;
            }
            case 201: {
                value = this.addressing.getImmediateValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 197: {
                value = this.addressing.getZeroPageValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 213: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 205: {
                value = this.addressing.getAbsoluteValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 221: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 217: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 193: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 209: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doCompare(value, this.getAccumulator());
                break;
            }
            case 224: {
                value = this.addressing.getImmediateValue();
                this.doCompare(value, this.getX());
                break;
            }
            case 228: {
                value = this.addressing.getZeroPageValue();
                this.doCompare(value, this.getX());
                break;
            }
            case 236: {
                value = this.addressing.getAbsoluteValue();
                this.doCompare(value, this.getX());
                break;
            }
            case 192: {
                value = this.addressing.getImmediateValue();
                this.doCompare(value, this.getY());
                break;
            }
            case 196: {
                value = this.addressing.getZeroPageValue();
                this.doCompare(value, this.getY());
                break;
            }
            case 204: {
                value = this.addressing.getAbsoluteValue();
                this.doCompare(value, this.getY());
                break;
            }
            case 198: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doDEC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 214: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doDEC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 206: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doDEC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 222: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doDEC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 202: {
                x = this.getX();
                --x;
                x = 0xFF & x;
                this.setX(x);
                this.checkNegativeBit(x);
                this.checkZero(x);
                break;
            }
            case 136: {
                y = this.getY();
                --y;
                y = 0xFF & y;
                this.setY(y);
                this.checkNegativeBit(y);
                this.checkZero(y);
                break;
            }
            case 73: {
                value = this.addressing.getImmediateValue();
                this.doEOR(value);
                break;
            }
            case 69: {
                value = this.addressing.getZeroPageValue();
                this.doEOR(value);
                break;
            }
            case 85: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doEOR(value);
                break;
            }
            case 77: {
                value = this.addressing.getAbsoluteValue();
                this.doEOR(value);
                break;
            }
            case 93: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doEOR(value);
                break;
            }
            case 89: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doEOR(value);
                break;
            }
            case 65: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doEOR(value);
                break;
            }
            case 81: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doEOR(value);
                break;
            }
            case 230: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doINC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 246: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doINC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 238: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doINC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 254: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doINC(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 232: {
                x = this.getX();
                ++x;
                this.setX(x &= 0xFF);
                this.checkNegativeBit(x);
                this.checkZero(x);
                break;
            }
            case 200: {
                y = this.getY();
                ++y;
                this.setY(y &= 0xFF);
                this.checkNegativeBit(y);
                this.checkZero(y);
                break;
            }
            case 76: {
                address = this.addressing.getAbsoluteAddress();
                this.cpuMemory.setProgramCounter(address);
                break;
            }
            case 108: {
                address = this.addressing.getIndirectAbsoluteAddress();
                this.cpuMemory.setProgramCounter(address);
                break;
            }
            case 32: {
                address = this.addressing.getAbsoluteAddress();
                int[] a = BitUtils.splitAddress(this.cpuMemory.getProgramCounter() - 1);
                this.cpuMemory.pushStack(a[1]);
                this.cpuMemory.pushStack(a[0]);
                this.cpuMemory.setProgramCounter(address);
                break;
            }
            case 169: {
                this.setAccumulator(this.addressing.getImmediateValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 165: {
                this.setAccumulator(this.addressing.getZeroPageValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 181: {
                this.setAccumulator(this.addressing.getZeroPageIndexedXValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 173: {
                this.setAccumulator(this.addressing.getAbsoluteValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 189: {
                this.setAccumulator(this.addressing.getAbsoluteIndexedXValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 185: {
                this.setAccumulator(this.addressing.getAbsoluteIndexedYValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 161: {
                this.setAccumulator(this.addressing.getIndexedIndirectXValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 177: {
                this.setAccumulator(this.addressing.getIndirectIndexedYValue());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 162: {
                this.setX(this.addressing.getImmediateValue());
                this.checkNegativeBit(this.getX());
                this.checkZero(this.getX());
                break;
            }
            case 166: {
                this.setX(this.addressing.getZeroPageValue());
                this.checkNegativeBit(this.getX());
                this.checkZero(this.getX());
                break;
            }
            case 182: {
                this.setX(this.addressing.getZeroPageIndexedYValue());
                this.checkNegativeBit(this.getX());
                this.checkZero(this.getX());
                break;
            }
            case 174: {
                this.setX(this.addressing.getAbsoluteValue());
                this.checkNegativeBit(this.getX());
                this.checkZero(this.getX());
                break;
            }
            case 190: {
                this.setX(this.addressing.getAbsoluteIndexedYValue());
                this.checkNegativeBit(this.getX());
                this.checkZero(this.getX());
                break;
            }
            case 160: {
                this.setY(this.addressing.getImmediateValue());
                this.checkNegativeBit(this.getY());
                this.checkZero(this.getY());
                break;
            }
            case 164: {
                this.setY(this.addressing.getZeroPageValue());
                this.checkNegativeBit(this.getY());
                this.checkZero(this.getY());
                break;
            }
            case 180: {
                this.setY(this.addressing.getZeroPageIndexedXValue());
                this.checkNegativeBit(this.getY());
                this.checkZero(this.getY());
                break;
            }
            case 172: {
                this.setY(this.addressing.getAbsoluteValue());
                this.checkNegativeBit(this.getY());
                this.checkZero(this.getY());
                break;
            }
            case 188: {
                this.setY(this.addressing.getAbsoluteIndexedXValue());
                this.checkNegativeBit(this.getY());
                this.checkZero(this.getY());
                break;
            }
            case 74: {
                value = this.getAccumulator();
                value = this.doLSR(value);
                this.setAccumulator(value);
                break;
            }
            case 70: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doLSR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 86: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doLSR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 78: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doLSR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 94: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doLSR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 234: {
                break;
            }
            case 9: {
                value = this.addressing.getImmediateValue();
                this.doORA(value);
                break;
            }
            case 5: {
                value = this.addressing.getZeroPageValue();
                this.doORA(value);
                break;
            }
            case 21: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doORA(value);
                break;
            }
            case 13: {
                value = this.addressing.getAbsoluteValue();
                this.doORA(value);
                break;
            }
            case 29: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doORA(value);
                break;
            }
            case 25: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doORA(value);
                break;
            }
            case 1: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doORA(value);
                break;
            }
            case 17: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doORA(value);
                break;
            }
            case 72: {
                this.cpuMemory.pushStack(this.getAccumulator());
                break;
            }
            case 8: {
                this.pushStatus(true);
                break;
            }
            case 104: {
                this.setAccumulator(this.cpuMemory.popStack());
                this.checkNegativeBit(this.getAccumulator());
                this.checkZero(this.getAccumulator());
                break;
            }
            case 40: {
                this.pullStatus();
                break;
            }
            case 42: {
                value = this.getAccumulator();
                this.setAccumulator(this.doROL(value));
                break;
            }
            case 38: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 54: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 46: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 62: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROL(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 106: {
                value = this.getAccumulator();
                value = this.doROR(value);
                this.setAccumulator(value);
                break;
            }
            case 102: {
                address = this.addressing.getZeroPageAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 118: {
                address = this.addressing.getZeroPageIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 110: {
                address = this.addressing.getAbsoluteAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 126: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                value = this.cpuMemory.getMemoryFromHexAddress(address);
                value = this.doROR(value);
                this.cpuMemory.setMemoryFromHexAddress(address, value);
                break;
            }
            case 64: {
                this.pullStatus();
                int lowByte = this.cpuMemory.popStack();
                int highByte = this.cpuMemory.popStack();
                address = BitUtils.unsplitAddress(highByte, lowByte);
                this.cpuMemory.setProgramCounter(address);
                break;
            }
            case 96: {
                int lowByte = this.cpuMemory.popStack();
                int highByte = this.cpuMemory.popStack();
                address = BitUtils.unsplitAddress(highByte, lowByte);
                this.cpuMemory.setProgramCounter(address + 1);
                break;
            }
            case 233: {
                value = this.addressing.getImmediateValue();
                this.doSBC(value);
                break;
            }
            case 229: {
                value = this.addressing.getZeroPageValue();
                this.doSBC(value);
                break;
            }
            case 245: {
                value = this.addressing.getZeroPageIndexedXValue();
                this.doSBC(value);
                break;
            }
            case 237: {
                value = this.addressing.getAbsoluteValue();
                this.doSBC(value);
                break;
            }
            case 253: {
                value = this.addressing.getAbsoluteIndexedXValue();
                this.doSBC(value);
                break;
            }
            case 249: {
                value = this.addressing.getAbsoluteIndexedYValue();
                this.doSBC(value);
                break;
            }
            case 225: {
                value = this.addressing.getIndexedIndirectXValue();
                this.doSBC(value);
                break;
            }
            case 241: {
                value = this.addressing.getIndirectIndexedYValue();
                this.doSBC(value);
                break;
            }
            case 56: {
                this.getFlags().setCarry(true);
                break;
            }
            case 248: {
                this.getFlags().setDecimalMode(true);
                break;
            }
            case 120: {
                this.getFlags().setIrqDisable(true);
                break;
            }
            case 133: {
                address = this.addressing.getZeroPageAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 149: {
                address = this.addressing.getZeroPageIndexedXAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 141: {
                address = this.addressing.getAbsoluteAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 157: {
                address = this.addressing.getAbsoluteIndexedXAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 153: {
                address = this.addressing.getAbsoluteIndexedYAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 129: {
                address = this.addressing.getIndexedIndirectXAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 145: {
                address = this.addressing.getIndirectIndexedYAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getAccumulator());
                break;
            }
            case 134: {
                address = this.addressing.getZeroPageAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getX());
                break;
            }
            case 150: {
                address = this.addressing.getZeroPageIndexedYAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getX());
                break;
            }
            case 142: {
                address = this.addressing.getAbsoluteAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getX());
                break;
            }
            case 132: {
                address = this.addressing.getZeroPageAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getY());
                break;
            }
            case 148: {
                address = this.addressing.getZeroPageIndexedXAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getY());
                break;
            }
            case 140: {
                address = this.addressing.getAbsoluteAddress();
                this.cpuMemory.setMemoryFromHexAddress(address, this.getY());
                break;
            }
            case 170: {
                this.setX(this.getAccumulator());
                this.checkZero(this.getX());
                this.checkNegativeBit(this.getX());
                break;
            }
            case 168: {
                this.setY(this.getAccumulator());
                this.checkZero(this.getY());
                this.checkNegativeBit(this.getY());
                break;
            }
            case 186: {
                this.setX(this.cpuMemory.getStackPointer());
                this.checkZero(this.getX());
                this.checkNegativeBit(this.getX());
                break;
            }
            case 138: {
                this.setAccumulator(this.getX());
                this.checkZero(this.getAccumulator());
                this.checkNegativeBit(this.getAccumulator());
                break;
            }
            case 154: {
                this.cpuMemory.setStackPointer(this.getX());
                break;
            }
            case 152: {
                this.setAccumulator(this.getY());
                this.checkZero(this.getAccumulator());
                this.checkNegativeBit(this.getAccumulator());
                break;
            }
            case 12: {
                break;
            }
            case 28: {
                break;
            }
            case 60: {
                break;
            }
            case 92: {
                break;
            }
            case 124: {
                break;
            }
            case 220: {
                break;
            }
            case 252: {
                break;
            }
            default: {
                throw new IllegalStateException("ENCOUNTERED UNEMULATED INSTRUCTION: " + Integer.toHexString(instruction.getOpCode()));
            }
        }
        return instruction.getCycles();
    }

    private void doADC(int value) {
        int result = this.getAccumulator() + value + (this.getFlags().isCarry() ? 1 : 0);
        if (result >= 0 && result <= 255) {
            this.getFlags().setCarry(false);
        } else if (result > 255) {
            this.getFlags().setCarry(true);
        }
        int twosComplimentResult = (byte)value + (byte)this.getAccumulator() + (this.getFlags().isCarry() ? 1 : 0);
        this.getFlags().setOverflow(twosComplimentResult > 127 || twosComplimentResult < -128);
        this.checkNegativeBit(result &= 0xFF);
        this.checkZero(result);
        this.setAccumulator(result);
    }

    private void doAND(int value) {
        this.setAccumulator(this.getAccumulator() & value);
        this.checkNegativeBit(this.getAccumulator());
        this.checkZero(this.getAccumulator());
    }

    private int doASL(int value) {
        this.getFlags().setCarry(BitUtils.isBitSet(value, 7));
        value <<= 1;
        this.checkNegativeBit(value &= 0xFF);
        this.checkZero(value);
        return value;
    }

    private void doBIT(int value) {
        int maskedValue = this.getAccumulator() & value;
        this.checkZero(maskedValue);
        this.checkNegativeBit(value);
        this.getFlags().setOverflow(BitUtils.isBitSet(value, 6));
    }

    private void doBranch(int address) {
        this.cpuMemory.setProgramCounter(address);
    }

    private void doCompare(int value, int register) {
        if (register >= value) {
            this.getFlags().setCarry(true);
        } else {
            this.getFlags().setCarry(false);
        }
        int sub = register - value & 0xFF;
        this.getFlags().setNegative(BitUtils.isBitSet(sub, 7));
        if (register == value) {
            this.getFlags().setZero(true);
        } else {
            this.getFlags().setZero(false);
        }
    }

    private int doDEC(int value) {
        --value;
        this.checkNegativeBit(value &= 0xFF);
        this.checkZero(value);
        return value;
    }

    private void doEOR(int value) {
        this.setAccumulator(this.getAccumulator() ^ value);
        this.checkNegativeBit(this.getAccumulator());
        this.checkZero(this.getAccumulator());
    }

    private int doINC(int value) {
        ++value;
        this.checkNegativeBit(value &= 0xFF);
        this.checkZero(value);
        return value;
    }

    private int doLSR(int value) {
        this.getFlags().setCarry(BitUtils.isBitSet(value, 0));
        this.checkNegativeBit(value >>= 1);
        this.checkZero(value);
        return value;
    }

    private void doORA(int value) {
        this.setAccumulator(this.getAccumulator() | value);
        this.checkNegativeBit(this.getAccumulator());
        this.checkZero(this.getAccumulator());
    }

    private int doROL(int value) {
        boolean newCarry = BitUtils.isBitSet(value, 7);
        value = value << 1 & 0xFF;
        value = this.getFlags().isCarry() ? BitUtils.setBit(value, 0) : BitUtils.unsetBit(value, 0);
        this.getFlags().setCarry(newCarry);
        this.checkNegativeBit(value);
        this.checkZero(value);
        return value;
    }

    private int doROR(int value) {
        boolean newCarry = BitUtils.isBitSet(value, 0);
        value = value >> 1 & 0xFF;
        value = this.getFlags().isCarry() ? BitUtils.setBit(value, 7) : BitUtils.unsetBit(value, 7);
        this.getFlags().setCarry(newCarry);
        this.checkNegativeBit(value);
        this.checkZero(value);
        return value;
    }

    private void doSBC(int value) {
        int result = this.getAccumulator() - value - (1 - (this.getFlags().isCarry() ? 1 : 0));
        this.checkZero(result);
        this.checkNegativeBit(result);
        int twosComplimentResult = (byte)this.getAccumulator() - (byte)value - (1 - (this.getFlags().isCarry() ? 1 : 0));
        this.getFlags().setOverflow(twosComplimentResult > 127 || twosComplimentResult < -128);
        if (result >= 0 && result <= 255) {
            this.getFlags().setCarry(true);
        } else {
            this.getFlags().setCarry(false);
        }
        this.setAccumulator(result & 0xFF);
    }

    private void checkNegativeBit(int value) {
        if (BitUtils.isBitSet(value, 7)) {
            this.getFlags().setNegative(true);
        } else {
            this.getFlags().setNegative(false);
        }
    }

    private void checkZero(int value) {
        this.getFlags().setZero(value == 0);
    }

    @Override
    public void resetRegisters() {
        this.setAccumulator(0);
        this.setX(0);
        this.setY(0);
    }

    @Override
    public void pushStatus(boolean brk) throws IOException {
        int status = this.getStatus(brk);
        this.cpuMemory.pushStack(status);
    }

    @Override
    public void pullStatus() {
        int status = this.cpuMemory.popStack();
        this.getFlags().setNegative(BitUtils.isBitSet(status, 7));
        this.getFlags().setOverflow(BitUtils.isBitSet(status, 6));
        this.getFlags().setDecimalMode(BitUtils.isBitSet(status, 3));
        this.getFlags().setIrqDisable(BitUtils.isBitSet(status, 2));
        this.getFlags().setZero(BitUtils.isBitSet(status, 1));
        this.getFlags().setCarry(BitUtils.isBitSet(status, 0));
    }

    public int getStatus(boolean brk) {
        int status = (this.getFlags().isNegative() ? 1 : 0) << 7 | (this.getFlags().isOverflow() ? 1 : 0) << 6 | 0x20 | (brk ? 1 : 0) << 4 | (this.getFlags().isDecimalMode() ? 1 : 0) << 3 | (this.getFlags().isIrqDisable() ? 1 : 0) << 2 | (this.getFlags().isZero() ? 1 : 0) << 1 | (this.getFlags().isCarry() ? 1 : 0);
        return status;
    }

    public String toString() {
        return "X: " + this.getX() + "\n" + "Y: " + this.getY() + "\n" + "A: " + this.getAccumulator() + "\n" + "program counter: 0x" + Integer.toHexString(this.cpuMemory.getProgramCounter());
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getAccumulator() {
        return this.accumulator;
    }

    @Override
    public void setAccumulator(int accumulator) {
        this.accumulator = accumulator;
    }

    @Override
    public NesFlags getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags = (NesFlags)flags;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public NesCpuAddressingModes getAddressing() {
        return this.addressing;
    }

    public void setAddressing(NesCpuAddressingModes addressing) {
        this.addressing = addressing;
    }
}

