/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.cpu;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.util.BitUtils;
import org.apache.log4j.Logger;

public class NesCpuAddressingModes {
    private Logger logger = Logger.getLogger(NesCpuAddressingModes.class);
    private NesCpu cpu;
    private NesCpuMemory cpuMemory;

    public int getImmediateValue() {
        return this.getCpuMemory().getNextPrgRomByte();
    }

    public int getAbsoluteValue() {
        int address = this.getAbsoluteAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("using address: " + Integer.toHexString(address)));
        }
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getAbsoluteIndexedXValue() {
        int address = this.getAbsoluteIndexedXAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getAbsoluteIndexedYValue() {
        int address = this.getAbsoluteIndexedYAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getZeroPageValue() {
        int address = this.getZeroPageAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getIndirectAbsoluteValue() {
        int address = this.getIndirectAbsoluteAddress();
        return BitUtils.unsplitAddress(this.getCpuMemory().getMemoryFromHexAddress(address), this.getCpuMemory().getMemoryFromHexAddress(++address));
    }

    public int getZeroPageIndexedXValue() {
        int address = this.getZeroPageIndexedXAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getZeroPageIndexedYValue() {
        int address = this.getZeroPageIndexedYAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getIndexedIndirectXValue() {
        int address = this.getIndexedIndirectXAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getIndirectIndexedYValue() {
        int address = this.getIndirectIndexedYAddress();
        return this.getCpuMemory().getMemoryFromHexAddress(address);
    }

    public int getAbsoluteAddress() {
        int address = this.getCpuMemory().getNextPrgRomShort();
        return address;
    }

    public int getIndirectAbsoluteAddress() {
        int lsbAddress = this.getCpuMemory().getNextPrgRomShort();
        int lsb = this.getCpuMemory().getMemoryFromHexAddress(lsbAddress);
        int lsbAddressMsb = lsbAddress & 0xFF00;
        int lsbAddressLsb = lsbAddress & 0xFF;
        ++lsbAddressLsb;
        int msb = this.getCpuMemory().getMemoryFromHexAddress(lsbAddressMsb | (lsbAddressLsb &= 0xFF));
        return BitUtils.unsplitAddress(msb, lsb);
    }

    public int getAbsoluteIndexedXAddress() {
        int address = this.getCpuMemory().getNextPrgRomShort();
        return (address += this.getCpu().getX()) & 0xFFFF;
    }

    public int getAbsoluteIndexedYAddress() {
        int address = this.getCpuMemory().getNextPrgRomShort();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Y: " + Integer.toHexString(this.getCpu().getY())));
            this.logger.debug((Object)("Address: " + Integer.toHexString(address)));
        }
        return (address += this.getCpu().getY()) & 0xFFFF;
    }

    public int getZeroPageAddress() {
        return this.getCpuMemory().getNextPrgRomByte();
    }

    public int getZeroPageIndexedXAddress() {
        int address = this.getCpuMemory().getNextPrgRomByte();
        address += this.getCpu().getX();
        return address &= 0xFF;
    }

    public int getZeroPageIndexedYAddress() {
        int address = this.getCpuMemory().getNextPrgRomByte();
        address += this.getCpu().getY();
        return address &= 0xFF;
    }

    public int getIndexedIndirectXAddress() {
        int lowByteAddress = this.getCpuMemory().getNextPrgRomByte() + this.getCpu().getX() & 0xFF;
        int highByteAddress = lowByteAddress + 1 & 0xFF;
        return BitUtils.unsplitAddress(this.getCpuMemory().getMemoryFromHexAddress(highByteAddress), this.getCpuMemory().getMemoryFromHexAddress(lowByteAddress));
    }

    public int getIndirectIndexedYAddress() {
        int lowByteAddress = this.getCpuMemory().getNextPrgRomByte();
        int highByteAddress = lowByteAddress + 1 & 0xFF;
        int finalAddress = BitUtils.unsplitAddress(this.getCpuMemory().getMemoryFromHexAddress(highByteAddress), this.getCpuMemory().getMemoryFromHexAddress(lowByteAddress));
        return (finalAddress += this.getCpu().getY()) & 0xFFFF;
    }

    public int getRelativeAddress() {
        int offset = this.getCpuMemory().getNextPrgRomByte();
        if (offset > 127) {
            offset -= 256;
        }
        return offset + this.getCpuMemory().getProgramCounter();
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory memory) {
        this.cpuMemory = memory;
    }
}

