/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.interrupts;

import com.lambelly.lambnes.platform.cpu.NesCpu;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.interrupts.InterruptRequest;
import com.lambelly.lambnes.util.BitUtils;
import com.lambelly.lambnes.util.NumberConversionUtils;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class NesInterrupts {
    static final int NMI_INTERRUPT_ADDRESS = 65530;
    static final int RESET_INTERRUPT_ADDRESS = 65532;
    static final int IRQ_BRK_INTERRUPT_ADDRESS = 65534;
    private static int nmiInterruptJumpAddress = 0;
    private static int resetInterruptJumpAddress = 0;
    private static int irqBrkInterruptJumpAddress = 0;
    private NesCpu cpu;
    private NesCpuMemory cpuMemory;
    private Vector<InterruptRequest> interruptRequestQueue = new Vector();
    private Logger logger = Logger.getLogger(NesInterrupts.class);

    public void init() {
        NesInterrupts.setNmiInterruptJumpAddress(this.getJumpAddress(65530));
        NesInterrupts.setIrqBrkInterruptJumpAddress(this.getJumpAddress(65534));
        NesInterrupts.setResetInterruptJumpAddress(this.getJumpAddress(65532));
    }

    public int cycle() throws IOException {
        int cyclesPassed = 0;
        InterruptRequest ir = null;
        ir = this.getNextInterruptRequest();
        if (ir != null) {
            int[] a = BitUtils.splitAddress(this.getCpuMemory().getProgramCounter());
            this.getCpuMemory().pushStack(a[1]);
            this.getCpuMemory().pushStack(a[0]);
            this.getCpu().pushStatus(false);
            this.getCpu().getFlags().setIrqDisable(true);
            if (ir.getInterruptType() == 0) {
                this.getCpuMemory().setProgramCounter(NesInterrupts.getNmiInterruptJumpAddress());
            }
            ir.getInterruptType();
            if (ir.getInterruptType() == 2) {
                this.getCpuMemory().setProgramCounter(NesInterrupts.getResetInterruptJumpAddress());
            }
        }
        return cyclesPassed;
    }

    private int getJumpAddress(int baseAddress) {
        int lowerByte = this.getCpuMemory().getMemoryFromHexAddress(baseAddress);
        int higherByte = this.getCpuMemory().getMemoryFromHexAddress(baseAddress + 1);
        String hs = String.valueOf(Integer.toHexString(higherByte)) + NumberConversionUtils.generateHexStringWithleadingZeros(lowerByte, 2);
        return Integer.parseInt(hs, 16);
    }

    public static int getNmiInterruptJumpAddress() {
        return nmiInterruptJumpAddress;
    }

    public static void setNmiInterruptJumpAddress(int nmiInterruptJumpAddress) {
        NesInterrupts.nmiInterruptJumpAddress = nmiInterruptJumpAddress;
    }

    public static int getResetInterruptJumpAddress() {
        return resetInterruptJumpAddress;
    }

    public static void setResetInterruptJumpAddress(int resetInterruptJumpAddress) {
        NesInterrupts.resetInterruptJumpAddress = resetInterruptJumpAddress;
    }

    public static int getIrqBrkInterruptJumpAddress() {
        return irqBrkInterruptJumpAddress;
    }

    public static void setIrqBrkInterruptJumpAddress(int irqBrkInterruptJumpAddress) {
        NesInterrupts.irqBrkInterruptJumpAddress = irqBrkInterruptJumpAddress;
    }

    public Vector<InterruptRequest> getInterruptRequestQueue() {
        return this.interruptRequestQueue;
    }

    public void setInterruptRequestQueue(Vector<InterruptRequest> interruptRequestQueue) {
        this.interruptRequestQueue = interruptRequestQueue;
    }

    public void addInterruptRequestToQueue(InterruptRequest interruptRequest) {
        this.interruptRequestQueue.add(interruptRequest);
    }

    private InterruptRequest getNextInterruptRequest() {
        InterruptRequest ir = null;
        if (this.getInterruptRequestQueue().size() > 0) {
            ir = this.getInterruptRequestQueue().get(0);
            this.getInterruptRequestQueue().remove(0);
        }
        return ir;
    }

    public NesCpu getCpu() {
        return this.cpu;
    }

    public void setCpu(NesCpu cpu) {
        this.cpu = cpu;
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }
}

