/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.mappers;

import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.mappers.Mapper;
import com.lambelly.lambnes.platform.mappers.Mapper0;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MMC3Mapper
extends Mapper0
implements Mapper {
    private int[] prgRom = null;
    private int[] chrRom = null;
    private int[] prgRam = null;
    private boolean addressInvert = false;
    private int prgRomSwapControl = 0;
    private int swapModeControl = 0;
    private int mirroringControl = 0;
    private int prgRomBankMode = 0;
    private boolean prgRamChipEnabled = false;
    private Logger logger = Logger.getLogger(MMC3Mapper.class);
    public static final int PRM_ROM_SWAP_8000_BFFF = 0;
    public static final int PRG_ROM_SWAP_A000_DFFF = 1;
    public static final int PRG_ROM_BANK_MODE_8000_9FFF_SWAPPABLE = 0;
    public static final int PRG_ROM_BANK_MODE_C000_DFFF_SWAPPABLE = 1;
    public static final int CONTROL_SWAP_2_1K_CHR_ROM_0000 = 0;
    public static final int CONTROL_SWAP_2_1K_CHR_ROM_0800 = 1;
    public static final int CONTROL_SWAP_1K_CHR_ROM_1000 = 2;
    public static final int CONTROL_SWAP_1K_CHR_ROM_1400 = 3;
    public static final int CONTROL_SWAP_1K_CHR_ROM_1800 = 4;
    public static final int CONTROL_SWAP_1K_CHR_ROM_1C00 = 5;
    public static final int CONTROL_SWAP_8K_PRG_ROM_8000 = 6;
    public static final int CONTROL_SWAP_8K_PRG_ROM_A000 = 7;
    public static final int MIRRORING_VERTICAL = 0;
    public static final int MIRRORING_HORIZONTAL = 1;
    public static final int PRG_RAM_WRITE_ENABLED = 0;
    public static final int PRG_RAM_WRITE_DISABLED = 1;

    public MMC3Mapper(NesCpuMemory cpuMemory, NesPpuMemory ppuMemory) {
        this.setCpuMemory(cpuMemory);
        this.setPpuMemory(ppuMemory);
    }

    @Override
    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException, IOException {
        boolean addressEven;
        boolean bl = addressEven = address % 2 == 0;
        if (address >= 24576 && address <= Short.MAX_VALUE) {
            if (this.isPrgRamChipEnabled()) {
                int prgRamIndex = address & 0x1FFF;
                this.setPrgRamValue(prgRamIndex, value);
            } else {
                super.setMemoryFromHexAddress(address, value);
            }
        } else if (address >= 0 && address <= Short.MAX_VALUE) {
            super.setMemoryFromHexAddress(address, value);
        }
        if (address >= 8192 && address <= 16383) {
            if (this.getMirroringControl() == 0) {
                this.getPpuMemory().establishMirroring(1);
            } else {
                this.getPpuMemory().establishMirroring(0);
            }
        }
        if (address >= 16384 && address <= 24575) {
            this.logger.error((Object)"write to 0x4000 on MMC3, which isn't really implemented as of yet.");
        }
        if (address >= 24576 && address <= 28671) {
            this.logger.error((Object)"write to 0x6000 on MMC3, which isn't really implemented as of yet.");
        } else if (address >= 32768 && address <= 40959) {
            if (addressEven) {
                this.setAddressInvert((value & 0x80) != 0);
                this.setPrgRomBankMode((value & 0x40) >> 6);
                this.setSwapModeControl(value & 7);
                int banks = this.prgRom.length / 8192;
                if (this.getPrgRomBankMode() == 1) {
                    System.arraycopy(this.getPrgRom(), (banks - 2) * 8192, this.getCpuMemory().getMemory(), 32768, 8192);
                } else {
                    System.arraycopy(this.getPrgRom(), (banks - 2) * 8192, this.getCpuMemory().getMemory(), 49152, 8192);
                }
            } else {
                switch (this.swapModeControl()) {
                    case 0: {
                        this.logger.info((Object)("chr_rom 0000: address invert: " + this.isAddressInvert()));
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 0, 1024);
                            System.arraycopy(this.getChrRom(), (value + 1) * 1024, this.getPpuMemory().getPatternTable0(), 1024, 1024);
                            break;
                        }
                        System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 0, 1024);
                        System.arraycopy(this.getChrRom(), (value + 1) * 1024, this.getPpuMemory().getPatternTable1(), 1024, 1024);
                        break;
                    }
                    case 1: {
                        this.logger.info((Object)("chr_rom 0800: address invert: " + this.isAddressInvert()));
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 2048, 1024);
                            System.arraycopy(this.getChrRom(), (value + 1) * 1024, this.getPpuMemory().getPatternTable0(), 3072, 1024);
                            break;
                        }
                        System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 2048, 1024);
                        System.arraycopy(this.getChrRom(), (value + 1) * 1024, this.getPpuMemory().getPatternTable1(), 3072, 1024);
                        break;
                    }
                    case 2: {
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 0, 1024);
                            break;
                        }
                        this.logger.info((Object)("swapping 0x0000-0x03FF: " + value));
                        System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 0, 1024);
                        break;
                    }
                    case 3: {
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 1024, 1024);
                            break;
                        }
                        this.logger.info((Object)("swapping 0x0400-0x07FF: " + value));
                        System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 1024, 1024);
                        break;
                    }
                    case 4: {
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 2048, 1024);
                            break;
                        }
                        this.logger.info((Object)("swapping 0x0800-0x0BFF: " + value));
                        System.arraycopy(this.getPrgRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 2048, 1024);
                        break;
                    }
                    case 5: {
                        if (!this.isAddressInvert()) {
                            System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable1(), 3072, 1024);
                            break;
                        }
                        this.logger.info((Object)("swapping 0x0C00-0x0FFF: " + value));
                        System.arraycopy(this.getChrRom(), value * 1024, this.getPpuMemory().getPatternTable0(), 3072, 1024);
                        break;
                    }
                    case 6: {
                        this.logger.info((Object)("swapping out " + (this.prgRomBankMode == 0 ? "8000" : "C000") + " with bank " + value));
                        if (this.getPrgRomBankMode() == 0) {
                            System.arraycopy(this.getPrgRom(), value * 8192, this.getCpuMemory().getMemory(), 32768, 8192);
                            break;
                        }
                        System.arraycopy(this.getPrgRom(), value * 8192, this.getCpuMemory().getMemory(), 49152, 8192);
                        break;
                    }
                    case 7: {
                        this.logger.info((Object)("swapping out A000 with bank " + value));
                        System.arraycopy(this.getPrgRom(), value * 8192, this.getCpuMemory().getMemory(), 40960, 8192);
                    }
                }
            }
        } else if (address >= 40960 && address <= 49151) {
            if (addressEven) {
                this.logger.info((Object)("write to A000 register: " + value));
                this.setMirroringControl(value & 1);
            } else {
                this.logger.info((Object)("write to A001 register: " + value));
                int wram = (value & 0x80) >> 7;
                this.setPrgRamChipEnabled(wram != 1);
            }
        } else if (address >= 49152 && address <= 57343) {
            if (addressEven) {
                this.logger.info((Object)("write to C000 register: " + value));
            } else {
                this.logger.info((Object)("write to C001 register: " + value));
            }
        } else if (address >= 57344 && address <= 65535) {
            if (addressEven) {
                this.logger.info((Object)("write to E000 register: " + value));
            } else {
                this.logger.info((Object)("write to E001 register: " + value));
            }
        }
    }

    public int getPrgRomBankMode() {
        return this.prgRomBankMode;
    }

    public void setPrgRomBankMode(int prgRomBankMode) {
        this.prgRomBankMode = prgRomBankMode;
    }

    public boolean isPrgRamChipEnabled() {
        return this.prgRamChipEnabled;
    }

    public void setPrgRamChipEnabled(boolean prgRamChipEnabled) {
        this.prgRamChipEnabled = prgRamChipEnabled;
    }

    @Override
    public int getMemoryFromHexAddress(int address) {
        int value = 0;
        if (address >= 24576 && address <= Short.MAX_VALUE && this.isPrgRamChipEnabled()) {
            int prgRamIndex = address & 0x1FFF;
            value = this.getPrgRamValue(prgRamIndex);
        } else {
            value = super.getMemoryFromHexAddress(address);
        }
        return value;
    }

    @Override
    public void setProgramInstructions(int[] programInstructions) {
        this.setPrgRom(programInstructions);
        System.arraycopy(programInstructions, 0, this.getCpuMemory().getMemory(), 32768, 16384);
        System.arraycopy(programInstructions, programInstructions.length - 16384, this.getCpuMemory().getMemory(), 49152, 16384);
    }

    public int[] getPrgRam() {
        return this.prgRam;
    }

    public void setPrgRam(int[] prgRam) {
        this.prgRam = prgRam;
    }

    public int getPrgRamValue(int prgRamIndex) {
        return this.prgRam[prgRamIndex];
    }

    public void setPrgRamValue(int prgRamIndex, int value) {
        this.prgRam[prgRamIndex] = value;
    }

    public int[] getPrgRom() {
        return this.prgRom;
    }

    public void setPrgRom(int[] prgRom) {
        this.prgRom = prgRom;
    }

    public boolean isAddressInvert() {
        return this.addressInvert;
    }

    public void setAddressInvert(boolean addressInvert) {
        this.addressInvert = addressInvert;
    }

    public int getPrgRomSwapControl() {
        return this.prgRomSwapControl;
    }

    public void setPrgRomSwapControl(int prgRomSwapControl) {
        this.prgRomSwapControl = prgRomSwapControl;
    }

    public int swapModeControl() {
        return this.swapModeControl;
    }

    public void setSwapModeControl(int chrRomSwapControl) {
        this.swapModeControl = chrRomSwapControl;
    }

    public int getMirroringControl() {
        return this.mirroringControl;
    }

    public void setMirroringControl(int mirroringControl) {
        this.logger.info((Object)("mirroring control: " + mirroringControl));
        this.mirroringControl = mirroringControl;
    }

    public int[] getChrRom() {
        return this.chrRom;
    }

    @Override
    public void setChrRom(int[] chrRom) {
        this.chrRom = chrRom;
    }
}

