/*
 * Decompiled with CFR 0.152.
 */
package com.lambelly.lambnes.platform.mappers;

import com.lambelly.lambnes.platform.apu.registers.APUPulse1ChannelRegister;
import com.lambelly.lambnes.platform.cpu.NesCpuMemory;
import com.lambelly.lambnes.platform.mappers.Mapper;
import com.lambelly.lambnes.platform.ppu.NesPpuMemory;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class Mapper0
implements Mapper {
    private NesCpuMemory cpuMemory;
    private NesPpuMemory ppuMemory;
    private Logger logger = Logger.getLogger(Mapper0.class);

    @Override
    public int getMemoryFromHexAddress(int address) throws IllegalStateException {
        int value = 0;
        value = this.getCpuMemory().getMemory()[address];
        if (address >= 8192 && address <= 16383) {
            if (address > 8199) {
                address &= 0xFF;
                address %= 8;
                address += 8192;
            }
            if (address == 8192) {
                throw new IllegalStateException("reading from write only register: " + Integer.toHexString(address));
            }
            if (address == 8193) {
                throw new IllegalStateException("reading from write only register: " + Integer.toHexString(address));
            }
            if (address == 8195) {
                throw new IllegalStateException("reading from write only register: " + Integer.toHexString(address));
            }
            if (address == 8196) {
                value = this.getCpuMemory().getPpuSprRamIORegister().getRegisterValue();
            } else if (address == 8194) {
                value = this.getCpuMemory().getPpuStatusRegister().getRegisterValue();
            } else {
                if (address == 8197) {
                    throw new IllegalStateException("reading from write only register: " + Integer.toHexString(address));
                }
                if (address == 8198) {
                    throw new IllegalStateException("reading from write only register: " + Integer.toHexString(address));
                }
                if (address == 8199) {
                    value = this.getCpuMemory().getPpuVramIORegister().getRegisterValue();
                }
            }
        } else if (address >= 16384 && address <= 16415) {
            if (address == 16404) {
                throw new IllegalStateException("reading from write only register");
            }
            if (address == 16406) {
                value = this.getCpuMemory().getControlRegister1().getRegisterValue();
            } else if (address == 16407) {
                value = this.getCpuMemory().getControlRegister2().getRegisterValue();
            }
        }
        return value;
    }

    @Override
    public void setMemoryFromHexAddress(int address, int value) throws IllegalStateException, IOException {
        this.getCpuMemory().getMemory()[address] = value;
        if (address >= 8192 && address <= 16383) {
            if (address > 8199) {
                address &= 0xFF;
                address %= 8;
                address += 8192;
            }
            if (address == 8192) {
                this.getCpuMemory().getPpuControlRegister().setRegisterValue(value);
            } else if (address == 8193) {
                this.getCpuMemory().getPpuMaskRegister().setRegisterValue(value);
            } else if (address == 8195) {
                this.getCpuMemory().getPpuSprRamAddressRegister().setRegisterValue(value);
            } else if (address == 8196) {
                this.logger.info((Object)"write to 0x2004");
                this.getCpuMemory().getPpuSprRamIORegister().setRegisterValue(value);
            } else if (address == 8194) {
                this.getCpuMemory().getPpuStatusRegister().setRegisterValue(value);
            } else if (address == 8197) {
                this.getCpuMemory().getPpuScrollRegister().setRegisterValue(value);
            } else if (address == 8198) {
                this.getCpuMemory().getPpuVramAddressRegister().setRegisterValue(value);
            } else if (address == 8199) {
                this.getCpuMemory().getPpuVramIORegister().setRegisterValue(value);
            }
        } else if (address >= 16384 && address <= 16415) {
            if (address == 16384) {
                APUPulse1ChannelRegister.setRegisterValue(value);
            } else if (address == 16404) {
                this.getCpuMemory().getPpuSpriteDmaRegister().setRegisterValue(value);
            } else if (address == 16405) {
                this.getCpuMemory().getApuControlRegister().setRegisterValue(value);
            } else if (address == 16385) {
                this.getCpuMemory().getApuPulse1SweepRegister().setRegisterValue(value);
            } else if (address == 16386) {
                this.getCpuMemory().getApuPulse1TimerLowRegister().setRegisterValue(value);
            } else if (address == 16387) {
                this.getCpuMemory().getApuPulse1LengthCounterRegister().setRegisterValue(value);
            } else if (address == 16406) {
                this.getCpuMemory().getControlRegister1().setRegisterValue(value);
            } else if (address == 16407) {
                this.getCpuMemory().getControlRegister2().setRegisterValue(value);
                this.getCpuMemory().getApuFrameCounterRegister().setRegisterValue(value);
            }
        }
    }

    @Override
    public void setProgramInstructions(int[] programInstructions) {
        if (programInstructions.length > 16384) {
            this.logger.info((Object)("program instructions length: " + programInstructions.length));
            System.arraycopy(programInstructions, 0, this.getCpuMemory().getMemory(), 32768, programInstructions.length);
        } else if (programInstructions.length <= 16384) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"mirroring prg rom");
            }
            int i = 0;
            while (i < 32768 / programInstructions.length) {
                System.arraycopy(programInstructions, 0, this.getCpuMemory().getMemory(), 32768 + programInstructions.length * i, programInstructions.length);
                ++i;
            }
        }
    }

    @Override
    public void writeSavRam() throws IOException, FileNotFoundException {
    }

    public NesCpuMemory getCpuMemory() {
        return this.cpuMemory;
    }

    public void setCpuMemory(NesCpuMemory cpuMemory) {
        this.cpuMemory = cpuMemory;
    }

    public NesPpuMemory getPpuMemory() {
        return this.ppuMemory;
    }

    public void setPpuMemory(NesPpuMemory ppuMemory) {
        this.logger.info((Object)"setting ppu memory");
        this.ppuMemory = ppuMemory;
        this.logger.info((Object)("ppu memory is null: " + (this.getPpuMemory() == null)));
    }

    @Override
    public void setChrRom(int[] chrRom) {
        this.logger.info((Object)("ppu memory is null: " + (this.getPpuMemory() == null)));
        this.getPpuMemory().setPatternTiles(chrRom);
    }
}

